/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Environment;
import io.jooby.ExecutionMode;
import io.jooby.Jooby;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.test.JoobyTest;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class JoobyExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver,
TestInstancePostProcessor {
    private static final int DEFAULT_PORT = 8911;

    public void beforeAll(ExtensionContext context) throws Exception {
        context.getElement().ifPresent(SneakyThrows.throwingConsumer(element -> {
            JoobyTest metadata = element.getAnnotation(JoobyTest.class);
            if (metadata != null) {
                this.startApp(context, metadata);
            }
        }));
    }

    private Jooby startApp(ExtensionContext context, JoobyTest metadata) throws Exception {
        Jooby app;
        ServerOptions options = new ServerOptions();
        options.setPort(this.port(metadata.port(), 8911));
        Server server = Server.loadServer((ServerOptions)options);
        String factoryMethod = metadata.factoryMethod();
        if (factoryMethod.isEmpty()) {
            String defaultEnv = System.getProperty("application.env");
            System.setProperty("application.env", metadata.environment());
            app = Jooby.createApp((Server)server, (ExecutionMode)metadata.executionMode(), JoobyExtension.reflectionProvider(metadata.value()));
            if (defaultEnv != null) {
                System.setProperty("application.env", defaultEnv);
            } else {
                System.getProperties().remove("application.env");
            }
        } else {
            app = this.fromFactoryMethod(context, metadata, factoryMethod);
        }
        server.start(new Jooby[]{app});
        ExtensionContext.Store store = this.getStore(context);
        store.put((Object)"server", (Object)server);
        store.put((Object)"application", (Object)app);
        return app;
    }

    private static Supplier<Jooby> reflectionProvider(@NonNull Class<? extends Jooby> applicationType) {
        return () -> (Jooby)Stream.of(applicationType.getDeclaredConstructors()).filter(it -> it.getParameterCount() == 0).findFirst().map(SneakyThrows.throwingFunction(c -> c.newInstance(new Object[0]))).orElseThrow(() -> new IllegalArgumentException("Default constructor for: " + applicationType.getName()));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getElement().ifPresent(SneakyThrows.throwingConsumer(element -> {
            JoobyTest metadata = element.getAnnotation(JoobyTest.class);
            if (metadata != null) {
                this.startApp(context, metadata);
            }
        }));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Server server = (Server)this.getStore(context).get((Object)"server", Server.class);
        if (server != null) {
            server.stop();
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Server server = (Server)this.getStore(context).get((Object)"server", Server.class);
        if (server != null) {
            server.stop();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return this.joobyParameter(context, parameterContext) != null;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return this.joobyParameter(context, parameterContext).get();
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        Optional testMethod = context.getTestMethod();
        ExtensionContext.Namespace namespace = testMethod.map(m -> ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass(), m})).orElseGet(() -> ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass()}));
        return context.getStore(namespace);
    }

    private Supplier<Object> joobyParameter(ExtensionContext context, ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        return this.injectionPoint(context, parameter.getType(), () -> this.parameterName(parameter));
    }

    private String parameterName(Parameter parameter) {
        if (!parameter.isNamePresent()) {
            throw new IllegalStateException("Parameter injection requires parameter names to be present at runtime. Make sure compiler has the -parameters option");
        }
        return parameter.getName();
    }

    private Supplier<Object> injectionPoint(ExtensionContext context, Class type, Supplier<String> name) {
        if (Jooby.class.isAssignableFrom(type)) {
            return () -> this.application(context);
        }
        if (Environment.class.isAssignableFrom(type)) {
            return () -> this.application(context).getEnvironment();
        }
        if (Config.class.isAssignableFrom(type)) {
            return () -> this.application(context).getEnvironment().getConfig();
        }
        if (type == String.class && name.get().equals("serverPath")) {
            return () -> {
                Jooby app = this.application(context);
                Server server = this.server(context);
                return "http://localhost:" + server.getOptions().getPort() + app.getContextPath();
            };
        }
        if (type == Integer.TYPE && name.get().equals("serverPort")) {
            return () -> {
                Server server = this.server(context);
                return server.getOptions().getPort();
            };
        }
        return null;
    }

    private Jooby application(ExtensionContext context) {
        return this.service(context, "application", Jooby.class);
    }

    private Server server(ExtensionContext context) {
        return this.service(context, "server", Server.class);
    }

    private <T> T service(ExtensionContext context, String name, Class<T> type) {
        Object service = this.getStore(context).get((Object)name, type);
        if (service == null) {
            ExtensionContext parent = (ExtensionContext)context.getParent().orElseThrow(() -> new IllegalStateException("Not found: " + type.getSimpleName()));
            service = this.getStore(parent).get((Object)name, type);
        }
        if (service == null) {
            throw new IllegalStateException("Not found: " + type.getSimpleName());
        }
        return (T)service;
    }

    private int port(int port, int fallback) {
        return port == -1 ? fallback : port;
    }

    public void postProcessTestInstance(Object instance, ExtensionContext context) throws Exception {
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Supplier<Object> injectionPoint = this.injectionPoint(context, field.getType(), field::getName);
            if (injectionPoint == null) continue;
            field.setAccessible(true);
            field.set(instance, injectionPoint.get());
        }
    }

    private Jooby fromFactoryMethod(ExtensionContext context, JoobyTest metadata, String factoryMethod) throws Exception {
        Class factoryClass = metadata.factoryClass();
        if (factoryClass == Object.class) {
            factoryClass = context.getRequiredTestClass();
        }
        try {
            Method factory = factoryClass.getMethod(factoryMethod, new Class[0]);
            Class<?> returnType = factory.getReturnType();
            if (!Jooby.class.isAssignableFrom(returnType)) {
                throw new IllegalStateException("Factory method must return a Jooby application: " + String.valueOf(factory));
            }
            if (Modifier.isStatic(factory.getModifiers())) {
                return (Jooby)factory.invoke(null, new Object[0]);
            }
            return (Jooby)factory.invoke(context.getRequiredTestInstance(), new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw SneakyThrows.propagate((Throwable)e);
        }
    }

    static {
        System.setProperty("jooby.useShutdownHook", "false");
    }
}

