/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.MediaType;
import io.jooby.StatusCode;
import io.jooby.test.MockValue;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;

public class MockResponse
implements MockValue {
    private Object result;
    private StatusCode statusCode = StatusCode.OK;
    private Map<String, Object> headers = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private MediaType contentType;
    private long length = -1L;
    private CountDownLatch latch = new CountDownLatch(1);

    @NonNull
    public Map<String, Object> getHeaders() {
        return this.headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.headers);
    }

    @NonNull
    public MockResponse setHeaders(@NonNull Map<String, Object> headers) {
        headers.forEach(this::setHeader);
        return this;
    }

    @NonNull
    public MockResponse setHeader(@NonNull String name, @NonNull String value) {
        if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(MediaType.valueOf((String)value));
        } else if ("content-length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    @NonNull
    public MockResponse setHeader(@NonNull String name, @NonNull Object value) {
        return this.setHeader(name, value.toString());
    }

    @Nullable
    public MediaType getContentType() {
        return this.contentType == null ? MediaType.text : this.contentType;
    }

    @NonNull
    public MockResponse setContentType(@NonNull MediaType contentType) {
        this.contentType = contentType;
        this.headers.put("content-type", contentType.toContentTypeHeader(contentType.getCharset()));
        return this;
    }

    public long getContentLength() {
        return this.length;
    }

    @NonNull
    public MockResponse setContentLength(long length) {
        this.length = length;
        this.headers.put("content-length", Long.toString(length));
        return this;
    }

    @NonNull
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @NonNull
    public MockResponse setStatusCode(@NonNull StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    @Nullable
    public Object value() {
        return this.result;
    }

    @NonNull
    public MockResponse setResult(@Nullable Object result) {
        this.result = result;
        this.latch.countDown();
        return this;
    }

    CountDownLatch getLatch() {
        return this.latch;
    }
}

