/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ErrorHandler;
import io.jooby.Jooby;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.test.MockContext;
import io.jooby.test.MockResponse;
import io.jooby.test.MockSession;
import io.jooby.test.MockValue;
import io.jooby.test.MockWebSocketClient;
import io.jooby.test.MockWebSocketConfigurer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MockRouter {
    private static final Consumer NOOP = value -> {};
    private Executor worker;
    private Supplier<Jooby> supplier = () -> application;
    private boolean fullExecution;
    private MockSession session;

    public MockRouter(@NonNull Jooby application) {
    }

    @NonNull
    public MockRouter setSession(@NonNull MockSession session) {
        this.session = session;
        return this;
    }

    public Executor getWorker() {
        return this.worker;
    }

    public MockRouter setWorker(@NonNull Executor worker) {
        this.worker = worker;
        return this;
    }

    @NonNull
    public MockValue get(@NonNull String path) {
        return this.get(path, (Context)this.newContext());
    }

    public MockWebSocketClient ws(@NonNull String path, Consumer<MockWebSocketClient> callback) {
        MockValue value = this.get(path, (Context)this.newContext());
        if (value.value() instanceof MockWebSocketConfigurer) {
            MockWebSocketConfigurer configurer = value.value(MockWebSocketConfigurer.class);
            MockWebSocketClient client = configurer.getClient();
            configurer.ready();
            callback.accept(client);
            client.init();
            return client;
        }
        throw new IllegalArgumentException("No websocket fount at: " + path);
    }

    private MockContext newContext() {
        MockContext ctx = new MockContext();
        if (this.session != null) {
            new MockSession(ctx, this.session);
        }
        return ctx;
    }

    @NonNull
    public MockValue get(@NonNull String path, @NonNull Context context) {
        return this.call("GET", path, context);
    }

    public MockValue get(@NonNull String path, @NonNull Consumer<MockResponse> consumer) {
        return this.get(path, this.newContext(), consumer);
    }

    public MockValue get(@NonNull String path, @NonNull MockContext context, @NonNull Consumer<MockResponse> consumer) {
        return this.call("GET", path, context, consumer);
    }

    public MockValue post(@NonNull String path) {
        return this.post(path, (Context)this.newContext());
    }

    @NonNull
    public MockValue post(@NonNull String path, @NonNull Context context) {
        return this.call("POST", path, context);
    }

    public MockValue post(@NonNull String path, @NonNull Consumer<MockResponse> consumer) {
        return this.post(path, this.newContext(), consumer);
    }

    public MockValue post(@NonNull String path, @NonNull MockContext context, @NonNull Consumer<MockResponse> consumer) {
        return this.call("POST", path, context, consumer);
    }

    public MockValue delete(@NonNull String path) {
        return this.delete(path, (Context)this.newContext());
    }

    @NonNull
    public MockValue delete(@NonNull String path, @NonNull Context context) {
        return this.call("DELETE", path, context);
    }

    public MockValue delete(@NonNull String path, @NonNull Consumer<MockResponse> consumer) {
        return this.delete(path, this.newContext(), consumer);
    }

    public MockValue delete(@NonNull String path, @NonNull MockContext context, @NonNull Consumer<MockResponse> consumer) {
        return this.call("DELETE", path, context, consumer);
    }

    public MockValue put(@NonNull String path) {
        return this.put(path, (Context)this.newContext());
    }

    @NonNull
    public MockValue put(@NonNull String path, @NonNull Context context) {
        return this.call("PUT", path, context);
    }

    public MockValue put(@NonNull String path, @NonNull Consumer<MockResponse> consumer) {
        return this.put(path, this.newContext(), consumer);
    }

    public MockValue put(@NonNull String path, @NonNull MockContext context, @NonNull Consumer<MockResponse> consumer) {
        return this.call("PUT", path, context, consumer);
    }

    public MockValue patch(@NonNull String path) {
        return this.patch(path, (Context)this.newContext());
    }

    @NonNull
    public MockValue patch(@NonNull String path, @NonNull Context context) {
        return this.call("PATCH", path, context);
    }

    public MockValue patch(@NonNull String path, @NonNull Consumer<MockResponse> consumer) {
        return this.patch(path, this.newContext(), consumer);
    }

    public MockValue patch(@NonNull String path, @NonNull MockContext context, @NonNull Consumer<MockResponse> consumer) {
        return this.call("PATCH", path, context, consumer);
    }

    public MockValue call(@NonNull String method, @NonNull String path, @NonNull Context context) {
        return this.call(this.supplier.get(), method, path, context, NOOP);
    }

    public MockValue call(@NonNull String method, @NonNull String path, @NonNull Consumer<MockResponse> consumer) {
        return this.call(method, path, this.newContext(), consumer);
    }

    public MockValue call(@NonNull String method, @NonNull String path, @NonNull MockContext ctx, @NonNull Consumer<MockResponse> consumer) {
        return this.call(this.supplier.get(), method, path, (Context)ctx, consumer);
    }

    public MockRouter setFullExecution(boolean enabled) {
        this.fullExecution = enabled;
        return this;
    }

    public void tryError(Throwable cause, Consumer<MockResponse> consumer) {
        MockContext ctx = this.newContext();
        this.tryError(cause, (Context)ctx);
        consumer.accept(ctx.getResponse());
    }

    public void tryError(Throwable cause, Context ctx) {
        Jooby app = this.supplier.get();
        ErrorHandler handler = app.getErrorHandler();
        handler.apply(ctx, cause, app.errorCode(cause));
    }

    private MockValue call(Jooby router, String method, String path, Context ctx, Consumer<MockResponse> consumer) {
        boolean isCoroutine;
        MockContext findContext = ctx instanceof MockContext ? (MockContext)ctx : this.newContext();
        findContext.setMethod(method.toUpperCase());
        findContext.setRequestPath(path);
        findContext.setRouter((Router)router);
        findContext.setConsumer(consumer);
        findContext.setMockRouter(this);
        Router.Match match = router.match((Context)findContext);
        Route route = match.route();
        boolean bl = isCoroutine = route.getAttribute("coroutine") == Boolean.TRUE;
        if (isCoroutine) {
            router.setWorker(Optional.ofNullable(this.getWorker()).orElseGet(MockRouter::singleThreadWorker));
        }
        findContext.setPathMap((Map<String, String>)match.pathMap());
        findContext.setRoute(route);
        try {
            if (route.getMethod().equals("WS")) {
                WebSocket.Initializer initializer = ((WebSocket.Handler)route.getHandler()).getInitializer();
                MockWebSocketConfigurer configurer = new MockWebSocketConfigurer(ctx, initializer);
                return new SingleMockValue(configurer);
            }
            Route.Handler handler = this.fullExecution ? route.getPipeline() : route.getHandler();
            Object value = handler.apply(ctx);
            if (ctx instanceof MockContext) {
                Object responseValue;
                MockResponse response = ((MockContext)ctx).getResponse();
                if (isCoroutine) {
                    response.getLatch().await();
                    responseValue = response.value();
                } else {
                    if (value != null && !(value instanceof Context)) {
                        response.setResult(value);
                    }
                    responseValue = Optional.ofNullable(response.value()).orElse(value);
                }
                if (response.getContentLength() <= 0L) {
                    response.setContentLength(this.contentLength(responseValue));
                }
                consumer.accept(response);
                return new SingleMockValue(responseValue);
            }
            return new SingleMockValue(value);
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private long contentLength(Object value) {
        if (value instanceof CharSequence || value instanceof Number || value instanceof Boolean) {
            return value.toString().length();
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length;
        }
        return -1L;
    }

    private static Executor singleThreadWorker() {
        return Executors.newSingleThreadExecutor(task -> {
            Thread thread = new Thread(task, "single-thread");
            thread.setDaemon(true);
            return thread;
        });
    }

    private static class SingleMockValue
    implements MockValue {
        private final Object value;

        SingleMockValue(Object value) {
            this.value = value;
        }

        @Override
        @NonNull
        public Object value() {
            return this.value;
        }
    }
}

