/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Session;
import io.jooby.test.MockContext;
import io.jooby.value.Value;
import io.jooby.value.ValueFactory;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class MockSession
implements Session {
    private MockContext ctx;
    private String sessionId;
    private ValueFactory valueFactory = new ValueFactory();
    private Map<String, String> data = new HashMap<String, String>();
    private Instant creationTime;
    private Instant lastAccessedTime;
    private boolean isNew;
    private boolean modified;

    MockSession(@NonNull MockContext ctx, @NonNull MockSession session) {
        this.ctx = ctx.setSession(this);
        this.data = session.data;
        this.isNew = session.isNew;
        this.modified = session.modified;
        this.sessionId = session.sessionId;
        this.creationTime = session.creationTime;
        this.lastAccessedTime = session.lastAccessedTime;
    }

    public MockSession(@NonNull MockContext ctx, @NonNull String sessionId) {
        this.ctx = ctx.setSession(this);
        this.sessionId = sessionId;
        this.creationTime = Instant.now();
        this.lastAccessedTime = Instant.now();
    }

    public MockSession(@NonNull MockContext ctx) {
        this(ctx, UUID.randomUUID().toString());
    }

    public MockSession() {
        this.sessionId = UUID.randomUUID().toString();
        this.creationTime = Instant.now();
        this.lastAccessedTime = Instant.now();
    }

    @NonNull
    public String getId() {
        return this.sessionId;
    }

    @NonNull
    public MockSession setId(@Nullable String id) {
        this.sessionId = id;
        return this;
    }

    @NonNull
    public Value get(@NonNull String name) {
        return Optional.ofNullable(this.data.get(name)).map(value -> Value.create((ValueFactory)this.valueFactory, (String)name, (String)value)).orElse(Value.missing((String)name));
    }

    @NonNull
    public Session put(@NonNull String name, @NonNull String value) {
        this.data.put(name, value);
        return this;
    }

    @NonNull
    public Value remove(@NonNull String name) {
        Value value = this.get(name);
        this.data.remove(name);
        return value;
    }

    @NonNull
    public Map<String, String> toMap() {
        return this.data;
    }

    @NonNull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @NonNull
    public Session setCreationTime(@NonNull Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @NonNull
    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @NonNull
    public Session setLastAccessedTime(@NonNull Instant lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @NonNull
    public Session setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public boolean isModify() {
        return this.modified;
    }

    @NonNull
    public Session setModify(boolean modify) {
        this.modified = modify;
        return this;
    }

    public Session clear() {
        this.data.clear();
        return this;
    }

    public Session renewId() {
        return this;
    }

    public void destroy() {
        this.clear();
    }
}

