/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import io.jooby.test.MockWebSocket;
import io.jooby.test.MockWebSocketClient;
import org.slf4j.LoggerFactory;

public class MockWebSocketConfigurer
implements WebSocketConfigurer {
    private final Context ctx;
    private final MockWebSocketClient client;
    private final MockWebSocket ws;
    private WebSocket.OnClose onClose;
    private WebSocket.OnConnect onConnect;
    private WebSocket.OnMessage onMessage;
    private WebSocket.OnError onError;

    MockWebSocketConfigurer(Context ctx, WebSocket.Initializer initializer) {
        this.ctx = ctx;
        initializer.init(ctx, (WebSocketConfigurer)this);
        this.client = new MockWebSocketClient(this);
        this.ws = new MockWebSocket(ctx, this);
    }

    @NonNull
    public WebSocketConfigurer onConnect(@NonNull WebSocket.OnConnect callback) {
        this.onConnect = callback;
        return this;
    }

    @NonNull
    public WebSocketConfigurer onMessage(@NonNull WebSocket.OnMessage callback) {
        this.onMessage = callback;
        return this;
    }

    @NonNull
    public WebSocketConfigurer onError(@NonNull WebSocket.OnError callback) {
        this.onError = callback;
        return this;
    }

    @NonNull
    public WebSocketConfigurer onClose(@NonNull WebSocket.OnClose callback) {
        this.onClose = callback;
        return this;
    }

    MockWebSocketClient getClient() {
        return this.client;
    }

    void fireClientMessage(Object message) {
        this.client.fireMessage(message);
    }

    void ready() {
        try {
            if (this.onConnect != null) {
                this.onConnect.onConnect((WebSocket)this.ws);
            }
        }
        catch (Throwable x) {
            this.fireError(x);
        }
    }

    void fireOnMessage(Object message) {
        if (this.onMessage != null) {
            this.onMessage.onMessage((WebSocket)this.ws, message instanceof WebSocketMessage ? (WebSocketMessage)message : WebSocketMessage.create((Context)this.ctx, (String)message.toString()));
        }
    }

    void fireClose(WebSocketCloseStatus closeStatus) {
        if (this.onClose != null) {
            this.onClose.onClose((WebSocket)this.ws, closeStatus);
        }
        this.client.fireClose(closeStatus);
    }

    void fireError(Throwable cause) {
        if (this.onError != null) {
            this.onError.onError((WebSocket)this.ws, cause);
        } else {
            LoggerFactory.getLogger(MockWebSocket.class).error("WebSocket resulted in exception", cause);
        }
    }
}

