/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.thymeleaf;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.MapModelAndView;
import io.jooby.ModelAndView;
import io.jooby.TemplateEngine;
import io.jooby.buffer.DataBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.context.IContext;

public class ThymeleafTemplateEngine
implements TemplateEngine {
    private org.thymeleaf.TemplateEngine templateEngine;
    private List<String> extensions;

    public ThymeleafTemplateEngine(org.thymeleaf.TemplateEngine templateEngine, List<String> extensions) {
        this.templateEngine = templateEngine;
        this.extensions = Collections.unmodifiableList(extensions);
    }

    @NonNull
    public List<String> extensions() {
        return this.extensions;
    }

    @NonNull
    public DataBuffer render(Context ctx, ModelAndView<?> modelAndView) {
        if (modelAndView instanceof MapModelAndView) {
            MapModelAndView mapModelAndView = (MapModelAndView)modelAndView;
            HashMap model = new HashMap(ctx.getAttributes());
            model.putAll((Map)mapModelAndView.getModel());
            Locale locale = modelAndView.getLocale();
            if (locale == null) {
                locale = ctx.locale();
            }
            DataBuffer buffer = ctx.getBufferFactory().allocateBuffer();
            org.thymeleaf.context.Context context = new org.thymeleaf.context.Context(locale, model);
            Object templateName = modelAndView.getView();
            if (!((String)templateName).startsWith("/")) {
                templateName = "/" + (String)templateName;
            }
            this.templateEngine.process((String)templateName, (IContext)context, buffer.asWriter());
            return buffer;
        }
        throw new ModelAndView.UnsupportedModelAndView(new Class[]{MapModelAndView.class});
    }
}

