/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.thymeleaf;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import io.jooby.TemplateEngine;
import io.jooby.internal.thymeleaf.ThymeleafTemplateEngine;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafModule
implements Extension {
    private static final List<String> EXT = Arrays.asList(".thl", ".thl.html", ".html");
    private org.thymeleaf.TemplateEngine templateEngine;
    private String templatesPathString = "views";
    private Path templatesPath;

    public ThymeleafModule(@NonNull org.thymeleaf.TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public ThymeleafModule(@NonNull String templatesPath) {
        this.templatesPathString = templatesPath;
    }

    public ThymeleafModule(@NonNull Path templatesPath) {
        this.templatesPath = templatesPath;
    }

    public ThymeleafModule() {
        this("views");
    }

    public void install(@NonNull Jooby application) {
        if (this.templateEngine == null) {
            this.templateEngine = ThymeleafModule.create().setTemplatesPath(this.templatesPath).setTemplatesPath(this.templatesPathString).build(application.getEnvironment());
        }
        application.encoder((MessageEncoder)new ThymeleafTemplateEngine(this.templateEngine, EXT));
        ServiceRegistry services = application.getServices();
        services.put(org.thymeleaf.TemplateEngine.class, (Object)this.templateEngine);
    }

    @NonNull
    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private ITemplateResolver templateResolver;
        private String templatesPathString = "views";
        private Path templatesPath;
        private Boolean cacheable;
        private ICacheManager cacheManager;

        @NonNull
        public Builder setTemplatesPath(@NonNull String templatesPath) {
            this.templatesPathString = templatesPath;
            return this;
        }

        @NonNull
        public Builder setTemplatesPath(@NonNull Path templatesPath) {
            this.templatesPath = templatesPath;
            return this;
        }

        @NonNull
        public Builder setTemplateResolver(@NonNull ITemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }

        @NonNull
        public Builder setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        @NonNull
        public Builder setCacheManager(@NonNull ICacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        @NonNull
        public org.thymeleaf.TemplateEngine build(@NonNull Environment env) {
            org.thymeleaf.TemplateEngine engine = new org.thymeleaf.TemplateEngine();
            if (this.templateResolver == null) {
                String templatesPathString = TemplateEngine.normalizePath((String)env.getProperty("templates.path", Optional.ofNullable(this.templatesPathString).orElse("views")));
                this.templateResolver = this.defaultTemplateLoader(env, templatesPathString, this.templatesPath, this.cacheable);
            }
            engine.setTemplateResolver(this.templateResolver);
            Optional.ofNullable(this.cacheManager).ifPresent(arg_0 -> ((org.thymeleaf.TemplateEngine)engine).setCacheManager(arg_0));
            return engine;
        }

        private ITemplateResolver defaultTemplateLoader(Environment env, String templatesPathString, Path templatesPath, Boolean cacheable) {
            FileTemplateResolver resolver;
            Path templateDir = Optional.ofNullable(templatesPath).orElse(Paths.get(System.getProperty("user.dir"), templatesPathString));
            if (Files.exists(templateDir, new LinkOption[0])) {
                resolver = new FileTemplateResolver();
                resolver.setPrefix(templateDir.toAbsolutePath().toString());
            } else {
                resolver = new ClassLoaderTemplateResolver(env.getClassLoader());
                if (templatesPathString.startsWith("/")) {
                    resolver.setPrefix(templatesPathString);
                } else {
                    resolver.setPrefix("/" + templatesPathString);
                }
            }
            resolver.setForceSuffix(false);
            resolver.setTemplateMode(TemplateMode.HTML);
            if (cacheable == null) {
                resolver.setCacheable(!env.isActive("dev", new String[]{"test"}));
            } else {
                resolver.setCacheable(cacheable.booleanValue());
            }
            return resolver;
        }
    }
}

