/*
 * Decompiled with CFR 0.152.
 */
package io.justcount;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Operation {
    public final String realm;
    public final String tenant;
    public final String metric;
    public final Map<String, String> params = new HashMap<String, String>();
    public final Map<String, String> dimensions = new HashMap<String, String>();
    public final Date date;
    public final Op op;

    public Operation(String realm, String tenant, String metric, Map<String, String> params, Map<String, String> dimensions, Date date, Op op) {
        if (metric == null) {
            throw new IllegalArgumentException("An Operation must have a non-null metric");
        }
        if (op == null) {
            throw new IllegalArgumentException("An Operation must have a non-null op");
        }
        this.realm = realm;
        this.tenant = tenant;
        this.metric = metric;
        this.date = date;
        if (params != null) {
            this.params.putAll(params);
        }
        if (dimensions != null) {
            this.dimensions.putAll(dimensions);
        }
        this.op = op;
    }

    public static class Bulk {
        public Collection<Operation> bulk;

        public Bulk(Collection<Operation> operations) {
            this.bulk = operations;
        }
    }

    public static class Op {
        public final IntegerValue addInt;
        public final DoubleValue addFlt;
        public final IntegerValue setInt;
        public final DoubleValue setFlt;
        public final StringArrayValue insert;

        private Op(IntegerValue addInt, DoubleValue addFlt, IntegerValue setInt, DoubleValue setFlt, StringArrayValue insert) {
            this.addInt = addInt;
            this.addFlt = addFlt;
            this.setInt = setInt;
            this.setFlt = setFlt;
            this.insert = insert;
            int count = 0;
            if (this.addInt != null) {
                ++count;
            }
            if (this.addFlt != null) {
                ++count;
            }
            if (this.setInt != null) {
                ++count;
            }
            if (this.setFlt != null) {
                ++count;
            }
            if (this.insert != null) {
                ++count;
            }
            if (count != 1) {
                throw new IllegalArgumentException("An Op must have exactly one non-null member");
            }
        }

        public static Op AddInt(int value) {
            return new Op(new IntegerValue(value), null, null, null, null);
        }

        public static Op AddFlt(double value) {
            return new Op(null, new DoubleValue(value), null, null, null);
        }

        public static Op SetInt(int value) {
            return new Op(null, null, new IntegerValue(value), null, null);
        }

        public static Op SetFlt(double value) {
            return new Op(null, null, null, new DoubleValue(value), null);
        }

        public static Op Insert(Collection<String> value) {
            return new Op(null, null, null, null, new StringArrayValue(value));
        }

        public static class StringArrayValue {
            public final Collection<String> value;

            public StringArrayValue(Collection<String> value) {
                this.value = value == null ? null : new ArrayList<String>(value);
            }
        }

        public static class DoubleValue {
            public final double value;

            public DoubleValue(double value) {
                this.value = value;
            }
        }

        public static class IntegerValue {
            public final int value;

            public IntegerValue(int value) {
                this.value = value;
            }
        }
    }

    public static class Builder {
        public String realm;
        public String tenant;
        public String metric;
        public Date date;
        public Map<String, String> params = new HashMap<String, String>();
        public Map<String, String> dimensions = new HashMap<String, String>();
        public Op op;

        public Operation build() {
            return new Operation(this.realm, this.tenant, this.metric, this.params, this.dimensions, this.date, this.op);
        }

        public Builder setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        public Builder setParam(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public Builder setDimension(String name, String value) {
            this.dimensions.put(name, value);
            return this;
        }

        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setOp(Op op) {
            this.op = op;
            return this;
        }
    }
}

