/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.AddEventCallback;
import io.keen.client.java.KeenClient;
import io.keen.client.java.KeenLogging;
import io.keen.client.java.KeenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class KeenHttpRequestRunnable
implements Runnable {
    private final KeenClient keenClient;
    private final String eventCollection;
    private final Map<String, Object> event;
    private final AddEventCallback callback;

    KeenHttpRequestRunnable(KeenClient keenClient, String eventCollection, Map<String, Object> event, AddEventCallback callback) {
        this.keenClient = keenClient;
        this.eventCollection = eventCollection;
        this.event = event;
        this.callback = callback;
    }

    @Override
    public void run() {
        block2: {
            try {
                HttpURLConnection connection = this.sendEvent(this.eventCollection, this.event);
                KeenHttpRequestRunnable.handleResult(connection.getInputStream(), connection.getResponseCode(), this.callback);
            }
            catch (IOException e) {
                KeenLogging.log("There was an error while sending events to the Keen API.");
                String stackTrace = KeenUtils.getStackTraceFromThrowable(e);
                KeenLogging.log(stackTrace);
                if (this.callback == null) break block2;
                this.callback.onError(stackTrace);
            }
        }
    }

    HttpURLConnection sendEvent(String eventCollection, Map<String, Object> event) throws IOException {
        String urlString = String.format("%s/%s/projects/%s/events/%s", "https://api.keen.io", "3.0", this.keenClient.getProjectId(), eventCollection);
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Authorization", this.keenClient.getWriteKey());
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        KeenClient.MAPPER.writeValue(out, event);
        out.close();
        return connection;
    }

    static void handleResult(InputStream input, int responseCode, AddEventCallback callback) {
        if (responseCode == 201) {
            if (callback != null) {
                callback.onSuccess();
            }
        } else {
            KeenLogging.log(String.format("Response code was NOT 201. It was: %d", responseCode));
            String responseBody = KeenUtils.convertStreamToString(input);
            KeenLogging.log(String.format("Response body was: %s", responseBody));
            if (callback != null) {
                callback.onError(responseBody);
            }
        }
    }
}

