/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.keen.client.java.KeenClient;
import io.keen.client.java.exceptions.ScopedKeyException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class ScopedKeys {
    private static final int BLOCK_SIZE = 32;

    public static String encrypt(String apiKey, Map<String, Object> options) throws ScopedKeyException {
        try {
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            String paddedApiKey = ScopedKeys.padApiKey(apiKey);
            String jsonOptions = KeenClient.MAPPER.writeValueAsString(options);
            String paddedJsonOptions = ScopedKeys.pad(jsonOptions);
            SecretKeySpec secret = new SecretKeySpec(paddedApiKey.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] cipherText = cipher.doFinal(paddedJsonOptions.getBytes("UTF-8"));
            return new String(Hex.encodeHex((byte[])iv)) + new String(Hex.encodeHex((byte[])cipherText));
        }
        catch (Exception e) {
            throw new ScopedKeyException("An error occurred while attempting to encrypt a Scoped Key", e);
        }
    }

    public static Map<String, Object> decrypt(String apiKey, String scopedKey) throws ScopedKeyException {
        try {
            String paddedApiKey = ScopedKeys.padApiKey(apiKey);
            String hexedIv = scopedKey.substring(0, 32);
            String hexedCipherText = scopedKey.substring(32);
            byte[] iv = Hex.decodeHex((char[])hexedIv.toCharArray());
            byte[] cipherText = Hex.decodeHex((char[])hexedCipherText.toCharArray());
            SecretKeySpec secret = new SecretKeySpec(paddedApiKey.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)secret, ivParameterSpec);
            String plainText = new String(cipher.doFinal(cipherText), "UTF-8");
            String unPaddedPlainText = ScopedKeys.unPad(plainText);
            MapType javaType = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
            return (Map)KeenClient.MAPPER.readValue(unPaddedPlainText, (JavaType)javaType);
        }
        catch (Exception e) {
            throw new ScopedKeyException("An error occurred while attempting to decrypt a Scoped Key", e);
        }
    }

    private static String padApiKey(String apiKey) {
        if (apiKey.length() % 32 == 0) {
            return apiKey;
        }
        return ScopedKeys.pad(apiKey);
    }

    private static String pad(String input) {
        int paddingSize = 32 - input.length() % 32;
        String padding = "";
        for (int i = 0; i < paddingSize; ++i) {
            padding = padding + (char)paddingSize;
        }
        return input + padding;
    }

    private static String unPad(String input) {
        char paddingSize = input.charAt(input.length() - 1);
        return input.substring(0, input.length() - paddingSize);
    }
}

