/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataPublisherUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Set;
import javax.annotation.Nullable;
import org.greenrobot.essentials.collections.MultimapSet;

@Internal
class ObjectClassPublisher
implements DataPublisher<Class>,
Runnable {
    final BoxStore boxStore;
    final MultimapSet<Integer, DataObserver<Class>> observersByEntityTypeId = MultimapSet.create((MultimapSet.SetType)MultimapSet.SetType.THREAD_SAFE);
    final Deque<int[]> changesQueue = new ArrayDeque<int[]>();
    volatile boolean changePublisherRunning;

    ObjectClassPublisher(BoxStore boxStore) {
        this.boxStore = boxStore;
    }

    @Override
    public void subscribe(DataObserver<Class> observer, @Nullable Object forClass) {
        if (forClass == null) {
            for (int entityTypeId : this.boxStore.getAllEntityTypeIds()) {
                this.observersByEntityTypeId.putElement((Object)entityTypeId, observer);
            }
        } else {
            int entityTypeId = this.boxStore.getEntityTypeIdOrThrow((Class)forClass);
            this.observersByEntityTypeId.putElement((Object)entityTypeId, observer);
        }
    }

    @Override
    public void unsubscribe(DataObserver<Class> observer, @Nullable Object forClass) {
        if (forClass != null) {
            int entityTypeId = this.boxStore.getEntityTypeIdOrThrow((Class)forClass);
            this.unsubscribe(observer, entityTypeId);
        } else {
            for (int entityTypeId : this.boxStore.getAllEntityTypeIds()) {
                this.unsubscribe(observer, entityTypeId);
            }
        }
    }

    private void unsubscribe(DataObserver<Class> observer, int entityTypeId) {
        Set observers = (Set)this.observersByEntityTypeId.get((Object)entityTypeId);
        DataPublisherUtils.removeObserverFromCopyOnWriteSet(observers, observer);
    }

    @Override
    public void publishSingle(DataObserver<Class> observer, @Nullable Object forClass) {
        this.boxStore.internalScheduleThread(() -> {
            Collection<Class<Object>> entityClasses = forClass != null ? Collections.singletonList((Class)forClass) : this.boxStore.getAllEntityClasses();
            for (Class<Object> entityClass : entityClasses) {
                try {
                    observer.onData(entityClass);
                }
                catch (RuntimeException e) {
                    this.handleObserverException(entityClass);
                }
            }
        });
    }

    private void handleObserverException(Class objectClass) {
        RuntimeException newEx = new RuntimeException("Observer failed while processing data for " + objectClass + ". Consider using an ErrorObserver");
        newEx.printStackTrace();
        throw newEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish(int[] entityTypeIdsAffected) {
        Deque<int[]> deque = this.changesQueue;
        synchronized (deque) {
            this.changesQueue.add(entityTypeIdsAffected);
            if (!this.changePublisherRunning) {
                this.changePublisherRunning = true;
                this.boxStore.internalScheduleThread(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block8: while (true) {
                int[] entityTypeIdsAffected;
                Object object = this.changesQueue;
                synchronized (object) {
                    entityTypeIdsAffected = this.changesQueue.pollFirst();
                    if (entityTypeIdsAffected == null) {
                        this.changePublisherRunning = false;
                        break;
                    }
                }
                object = entityTypeIdsAffected;
                int n = ((Object)object).length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block8;
                    Object entityTypeId = object[n2];
                    Collection observers = this.observersByEntityTypeId.get((Object)((int)entityTypeId));
                    if (observers != null && !observers.isEmpty()) {
                        Class<?> objectClass = this.boxStore.getEntityClassOrThrow((int)entityTypeId);
                        try {
                            for (DataObserver observer : observers) {
                                observer.onData(objectClass);
                            }
                        }
                        catch (RuntimeException e) {
                            this.handleObserverException(objectClass);
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
        finally {
            this.changePublisherRunning = false;
        }
    }
}

