/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.internal;

import io.objectbox.BoxStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.greenrobot.essentials.io.IoUtils;

public class NativeLibraryLoader {
    private static final String OBJECTBOX_JNI = "objectbox-jni";

    private static String getCpuArch() {
        String osArch = System.getProperty("os.arch");
        String cpuArch = null;
        if (osArch != null) {
            if ((osArch = osArch.toLowerCase()).equalsIgnoreCase("amd64") || osArch.equalsIgnoreCase("x86_64")) {
                cpuArch = "x64";
            } else if (osArch.equalsIgnoreCase("x86")) {
                cpuArch = "x86";
            } else if (osArch.startsWith("arm")) {
                switch (osArch) {
                    case "armv7": 
                    case "armv7l": 
                    case "armeabi-v7a": {
                        cpuArch = "armv7";
                        break;
                    }
                    case "arm64-v8a": {
                        cpuArch = "arm64";
                        break;
                    }
                    case "armv6": {
                        cpuArch = "armv6";
                        break;
                    }
                    default: {
                        cpuArch = "armv6";
                        System.err.println("Unknown os.arch \"" + osArch + "\" - ObjectBox is defaulting to " + cpuArch);
                    }
                }
            }
        }
        if (cpuArch == null) {
            String sunArch = System.getProperty("sun.arch.data.model");
            cpuArch = "32".equals(sunArch) ? "x86" : "x64";
            System.err.println("Unknown os.arch \"" + osArch + "\" - ObjectBox is defaulting to " + cpuArch);
        }
        return cpuArch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUnpackLib(String filename) {
        block11: {
            String path = "/native/" + filename;
            URL resource = NativeLibraryLoader.class.getResource(path);
            if (resource == null) {
                System.err.println("Not available in classpath: " + path);
            } else {
                File file = new File(filename);
                try {
                    URLConnection urlConnection = resource.openConnection();
                    int length = urlConnection.getContentLength();
                    long lastModified = urlConnection.getLastModified();
                    if (file.exists() && file.length() == (long)length && file.lastModified() == lastModified) break block11;
                    BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                        try {
                            IoUtils.copyAllBytes((InputStream)in, (OutputStream)out);
                        }
                        finally {
                            IoUtils.safeClose((Closeable)out);
                        }
                    }
                    finally {
                        IoUtils.safeClose((Closeable)in);
                    }
                    if (lastModified > 0L) {
                        file.setLastModified(lastModified);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean loadLibraryAndroid() {
        if (BoxStore.getContext() == null) {
            return false;
        }
        try {
            Class<?> context = Class.forName("android.content.Context");
            if (BoxStore.getRelinker() == null) {
                Class<?> relinker = Class.forName("com.getkeepsafe.relinker.ReLinker");
                Method loadLibrary = relinker.getMethod("loadLibrary", context, String.class, String.class);
                loadLibrary.invoke(null, BoxStore.getContext(), OBJECTBOX_JNI, "2.8.0");
            } else {
                Method loadLibrary = BoxStore.getRelinker().getClass().getMethod("loadLibrary", context, String.class, String.class);
                loadLibrary.invoke(BoxStore.getRelinker(), BoxStore.getContext(), OBJECTBOX_JNI, "2.8.0");
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static void ensureLoaded() {
    }

    static {
        block16: {
            String libname = OBJECTBOX_JNI;
            String filename = libname + ".so";
            String vendor = System.getProperty("java.vendor");
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isLinux = true;
            boolean android = vendor.contains("Android");
            if (!android) {
                String cpuArchPostfix = "-" + NativeLibraryLoader.getCpuArch();
                if (osName.contains("windows")) {
                    isLinux = false;
                    libname = libname + "-windows" + cpuArchPostfix;
                    filename = libname + ".dll";
                    NativeLibraryLoader.checkUnpackLib(filename);
                } else if (osName.contains("linux")) {
                    libname = libname + "-linux" + cpuArchPostfix;
                    filename = "lib" + libname + ".so";
                    NativeLibraryLoader.checkUnpackLib(filename);
                } else if (osName.contains("mac")) {
                    isLinux = false;
                    libname = libname + "-macos" + cpuArchPostfix;
                    filename = "lib" + libname + ".dylib";
                    NativeLibraryLoader.checkUnpackLib(filename);
                }
            }
            try {
                File file = new File(filename);
                if (file.exists()) {
                    System.load(file.getAbsolutePath());
                    break block16;
                }
                try {
                    if (android) {
                        boolean success = NativeLibraryLoader.loadLibraryAndroid();
                        if (!success) {
                            System.loadLibrary(libname);
                        }
                    } else {
                        System.err.println("File not available: " + file.getAbsolutePath());
                        System.loadLibrary(libname);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    if (!android && isLinux) {
                        boolean success = NativeLibraryLoader.loadLibraryAndroid();
                        if (!success) {
                            System.loadLibrary(OBJECTBOX_JNI);
                        }
                        break block16;
                    }
                    throw e;
                }
            }
            catch (UnsatisfiedLinkError e) {
                String osArch = System.getProperty("os.arch");
                String sunArch = System.getProperty("sun.arch.data.model");
                String message = String.format("Loading ObjectBox native library failed: vendor=%s,os=%s,os.arch=%s,sun.arch=%s,android=%s,linux=%s", vendor, osName, osArch, sunArch, android, isLinux);
                throw new LinkageError(message, e);
            }
        }
    }
}

