/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.EntityInfo;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.converter.PropertyConverter;
import io.objectbox.exception.DbException;
import io.objectbox.query.QueryCondition;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;

public class Property<ENTITY>
implements Serializable {
    private static final long serialVersionUID = 8613291105982758093L;
    public final EntityInfo<ENTITY> entity;
    public final int ordinal;
    public final int id;
    public final Class<?> type;
    public final String name;
    public final boolean isId;
    public final boolean isVirtual;
    public final String dbName;
    public final Class<? extends PropertyConverter<?, ?>> converterClass;
    public final Class<?> customType;
    private boolean idVerified;

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name) {
        this(entity, ordinal, id, type, name, false, name, null, null);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isVirtual) {
        this(entity, ordinal, id, type, name, false, isVirtual, name, null, null);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isId, @Nullable String dbName) {
        this(entity, ordinal, id, type, name, isId, dbName, null, null);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isId, @Nullable String dbName, @Nullable Class<? extends PropertyConverter<?, ?>> converterClass, @Nullable Class<?> customType) {
        this(entity, ordinal, id, type, name, isId, false, dbName, converterClass, customType);
    }

    public Property(EntityInfo<ENTITY> entity, int ordinal, int id, Class<?> type, String name, boolean isId, boolean isVirtual, @Nullable String dbName, @Nullable Class<? extends PropertyConverter<?, ?>> converterClass, @Nullable Class<?> customType) {
        this.entity = entity;
        this.ordinal = ordinal;
        this.id = id;
        this.type = type;
        this.name = name;
        this.isId = isId;
        this.isVirtual = isVirtual;
        this.dbName = dbName;
        this.converterClass = converterClass;
        this.customType = customType;
    }

    public QueryCondition eq(Object value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.EQUALS, value);
    }

    public QueryCondition notEq(Object value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.NOT_EQUALS, value);
    }

    public QueryCondition between(Object value1, Object value2) {
        Object[] values = new Object[]{value1, value2};
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.BETWEEN, values);
    }

    public QueryCondition in(Object ... inValues) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.IN, inValues);
    }

    public QueryCondition in(Collection<?> inValues) {
        return this.in(inValues.toArray());
    }

    public QueryCondition gt(Object value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.GREATER_THAN, value);
    }

    public QueryCondition lt(Object value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.LESS_THAN, value);
    }

    public QueryCondition isNull() {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.IS_NULL, null);
    }

    public QueryCondition isNotNull() {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.IS_NOT_NULL, null);
    }

    public QueryCondition contains(String value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.CONTAINS, value);
    }

    public QueryCondition startsWith(String value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.STARTS_WITH, value);
    }

    public QueryCondition endsWith(String value) {
        return new QueryCondition.PropertyCondition(this, QueryCondition.PropertyCondition.Operation.ENDS_WITH, value);
    }

    @Internal
    public int getEntityId() {
        return this.entity.getEntityId();
    }

    @Internal
    public int getId() {
        if (this.id <= 0) {
            throw new IllegalStateException("Illegal property ID " + this.id + " for " + this.toString());
        }
        return this.id;
    }

    boolean isIdVerified() {
        return this.idVerified;
    }

    void verifyId(int idInDb) {
        if (this.id <= 0) {
            throw new IllegalStateException("Illegal property ID " + this.id + " for " + this.toString());
        }
        if (this.id != idInDb) {
            throw new DbException(this.toString() + " does not match ID in DB: " + idInDb);
        }
        this.idVerified = true;
    }

    public String toString() {
        return "Property \"" + this.name + "\" (ID: " + this.id + ")";
    }
}

