/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Property;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.DbException;
import io.objectbox.query.Query;
import io.objectbox.query.QueryBuilder;
import java.util.Date;
import javax.annotation.Nullable;

@Experimental
@Internal
public interface QueryCondition {
    public void applyTo(QueryBuilder var1, QueryBuilder.StringOrder var2);

    public void setParameterFor(Query var1, Object var2);

    public void setParameterFor(Query var1, Object var2, Object var3);

    public static class PropertyCondition
    extends AbstractCondition {
        public final Property property;
        private final Operation operation;

        public PropertyCondition(Property property, Operation operation, @Nullable Object value) {
            super(PropertyCondition.checkValueForType(property, value));
            this.property = property;
            this.operation = operation;
        }

        public PropertyCondition(Property property, Operation operation, @Nullable Object[] values) {
            super(PropertyCondition.checkValuesForType(property, operation, values));
            this.property = property;
            this.operation = operation;
        }

        @Override
        public void applyTo(QueryBuilder queryBuilder, QueryBuilder.StringOrder stringOrder) {
            if (this.operation == Operation.EQUALS) {
                if (this.value instanceof Long) {
                    queryBuilder.equal(this.property, (Long)this.value);
                } else if (this.value instanceof Integer) {
                    queryBuilder.equal(this.property, ((Integer)this.value).intValue());
                } else if (this.value instanceof String) {
                    queryBuilder.equal(this.property, (String)this.value, stringOrder);
                }
            } else if (this.operation == Operation.NOT_EQUALS) {
                if (this.value instanceof Long) {
                    queryBuilder.notEqual(this.property, (Long)this.value);
                } else if (this.value instanceof Integer) {
                    queryBuilder.notEqual(this.property, ((Integer)this.value).intValue());
                } else if (this.value instanceof String) {
                    queryBuilder.notEqual(this.property, (String)this.value, stringOrder);
                }
            } else if (this.operation == Operation.BETWEEN) {
                if (this.values[0] instanceof Long && this.values[1] instanceof Long) {
                    queryBuilder.between(this.property, (Long)this.values[0], (Long)this.values[1]);
                } else if (this.values[0] instanceof Integer && this.values[1] instanceof Integer) {
                    queryBuilder.between(this.property, ((Integer)this.values[0]).intValue(), ((Integer)this.values[1]).intValue());
                } else if (this.values[0] instanceof Double && this.values[1] instanceof Double) {
                    queryBuilder.between(this.property, (Double)this.values[0], (Double)this.values[1]);
                } else if (this.values[0] instanceof Float && this.values[1] instanceof Float) {
                    queryBuilder.between(this.property, ((Float)this.values[0]).floatValue(), ((Float)this.values[1]).floatValue());
                }
            } else if (this.operation == Operation.IN) {
                if (this.values[0] instanceof Long) {
                    long[] inValues = new long[this.values.length];
                    for (int i = 0; i < this.values.length; ++i) {
                        inValues[i] = (Long)this.values[i];
                    }
                    queryBuilder.in(this.property, inValues);
                } else if (this.values[0] instanceof Integer) {
                    int[] inValues = new int[this.values.length];
                    for (int i = 0; i < this.values.length; ++i) {
                        inValues[i] = (Integer)this.values[i];
                    }
                    queryBuilder.in(this.property, inValues);
                }
            } else if (this.operation == Operation.GREATER_THAN) {
                if (this.value instanceof Long) {
                    queryBuilder.greater(this.property, (Long)this.value);
                } else if (this.value instanceof Integer) {
                    queryBuilder.greater(this.property, ((Integer)this.value).intValue());
                } else if (this.value instanceof Double) {
                    queryBuilder.greater(this.property, (Double)this.value);
                } else if (this.value instanceof Float) {
                    queryBuilder.greater(this.property, ((Float)this.value).floatValue());
                }
            } else if (this.operation == Operation.LESS_THAN) {
                if (this.value instanceof Long) {
                    queryBuilder.less(this.property, (Long)this.value);
                } else if (this.value instanceof Integer) {
                    queryBuilder.less(this.property, ((Integer)this.value).intValue());
                } else if (this.value instanceof Double) {
                    queryBuilder.less(this.property, (Double)this.value);
                } else if (this.value instanceof Float) {
                    queryBuilder.less(this.property, ((Float)this.value).floatValue());
                }
            } else if (this.operation == Operation.IS_NULL) {
                queryBuilder.isNull(this.property);
            } else if (this.operation == Operation.IS_NOT_NULL) {
                queryBuilder.notNull(this.property);
            } else if (this.operation == Operation.CONTAINS) {
                queryBuilder.contains(this.property, (String)this.value, stringOrder);
            } else if (this.operation == Operation.STARTS_WITH) {
                queryBuilder.startsWith(this.property, (String)this.value, stringOrder);
            } else if (this.operation == Operation.ENDS_WITH) {
                queryBuilder.endsWith(this.property, (String)this.value, stringOrder);
            } else {
                throw new UnsupportedOperationException("This operation is not known.");
            }
        }

        private static Object checkValueForType(Property property, @Nullable Object value) {
            if (value != null && value.getClass().isArray()) {
                throw new DbException("Illegal value: found array, but simple object required");
            }
            Class<?> type = property.type;
            if (type == Date.class) {
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Long) {
                    return value;
                }
                throw new DbException("Illegal date value: expected java.util.Date or Long for value " + value);
            }
            if (property.type == Boolean.TYPE || property.type == Boolean.class) {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (value instanceof Number) {
                    int intValue = ((Number)value).intValue();
                    if (intValue != 0 && intValue != 1) {
                        throw new DbException("Illegal boolean value: numbers must be 0 or 1, but was " + value);
                    }
                } else if (value instanceof String) {
                    String stringValue = (String)value;
                    if ("TRUE".equalsIgnoreCase(stringValue)) {
                        return 1;
                    }
                    if ("FALSE".equalsIgnoreCase(stringValue)) {
                        return 0;
                    }
                    throw new DbException("Illegal boolean value: Strings must be \"TRUE\" or \"FALSE\" (case insensitive), but was " + value);
                }
            }
            return value;
        }

        private static Object[] checkValuesForType(Property property, Operation operation, @Nullable Object[] values) {
            if (values == null) {
                if (operation == Operation.IS_NULL || operation == Operation.IS_NOT_NULL) {
                    return null;
                }
                throw new IllegalArgumentException("This operation requires non-null values.");
            }
            for (int i = 0; i < values.length; ++i) {
                values[i] = PropertyCondition.checkValueForType(property, values[i]);
            }
            return values;
        }

        @Override
        public void setParameterFor(Query query, Object parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException("The new parameter can not be null.");
            }
            if (this.operation == Operation.BETWEEN) {
                throw new UnsupportedOperationException("The BETWEEN condition requires two parameters.");
            }
            if (this.operation == Operation.IN) {
                throw new UnsupportedOperationException("The IN condition does not support changing parameters.");
            }
            if (parameter instanceof Long) {
                query.setParameter(this.property, (long)((Long)parameter));
            } else if (parameter instanceof Integer) {
                query.setParameter(this.property, (long)((Integer)parameter).intValue());
            } else if (parameter instanceof String) {
                query.setParameter(this.property, (String)parameter);
            } else if (parameter instanceof Double) {
                query.setParameter(this.property, (double)((Double)parameter));
            } else if (parameter instanceof Float) {
                query.setParameter(this.property, (double)((Float)parameter).floatValue());
            } else {
                throw new IllegalArgumentException("Only LONG, INTEGER, DOUBLE, FLOAT or STRING parameters are supported.");
            }
        }

        @Override
        public void setParameterFor(Query query, Object parameter1, Object parameter2) {
            if (parameter1 == null || parameter2 == null) {
                throw new IllegalArgumentException("The new parameters can not be null.");
            }
            if (this.operation != Operation.BETWEEN) {
                throw new UnsupportedOperationException("Only the BETWEEN condition supports two parameters.");
            }
            if (parameter1 instanceof Long && parameter2 instanceof Long) {
                query.setParameters(this.property, (long)((Long)parameter1), (long)((Long)parameter2));
            } else if (parameter1 instanceof Integer && parameter2 instanceof Integer) {
                query.setParameters(this.property, (long)((Integer)parameter1).intValue(), (long)((Integer)parameter2).intValue());
            } else if (parameter1 instanceof Double && parameter2 instanceof Double) {
                query.setParameters(this.property, (double)((Double)parameter1), (double)((Double)parameter2));
            } else if (parameter1 instanceof Float && parameter2 instanceof Float) {
                query.setParameters(this.property, (double)((Float)parameter1).floatValue(), (double)((Float)parameter2).floatValue());
            } else {
                throw new IllegalArgumentException("The BETWEEN condition only supports LONG, INTEGER, DOUBLE or FLOAT parameters.");
            }
        }

        public static enum Operation {
            EQUALS,
            NOT_EQUALS,
            BETWEEN,
            IN,
            GREATER_THAN,
            LESS_THAN,
            IS_NULL,
            IS_NOT_NULL,
            CONTAINS,
            STARTS_WITH,
            ENDS_WITH;

        }
    }

    public static abstract class AbstractCondition
    implements QueryCondition {
        public final Object value;
        protected final Object[] values;

        AbstractCondition(Object value) {
            this.value = value;
            this.values = null;
        }

        AbstractCondition(@Nullable Object[] values) {
            this.value = null;
            this.values = values;
        }
    }
}

