/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.sync.SyncClient;
import io.objectbox.sync.SyncClientImpl;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.internal.Platform;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.listener.SyncCompletedListener;
import io.objectbox.sync.listener.SyncConnectionListener;
import io.objectbox.sync.listener.SyncListener;
import io.objectbox.sync.listener.SyncLoginListener;
import java.util.Arrays;
import javax.annotation.Nullable;

@Experimental
public class SyncBuilder {
    final Platform platform;
    final BoxStore boxStore;
    final String url;
    final SyncCredentials credentials;
    @Nullable
    SyncLoginListener loginListener;
    @Nullable
    SyncCompletedListener completedListener;
    @Nullable
    SyncChangeListener changeListener;
    @Nullable
    SyncConnectionListener connectionListener;
    @Nullable
    SyncListener listener;
    @Nullable
    String[] trustedCertPaths;
    boolean uncommittedAcks;
    RequestUpdatesMode requestUpdatesMode = RequestUpdatesMode.AUTO;

    public SyncBuilder(BoxStore boxStore, String url, SyncCredentials credentials) {
        this.checkNotNull(boxStore, "BoxStore is required.");
        this.checkNotNull(url, "Sync server URL is required.");
        this.checkNotNull(credentials, "Sync credentials are required.");
        if (!BoxStore.isSyncAvailable()) {
            throw new IllegalStateException("This library does not include ObjectBox Sync. Please visit https://objectbox.io/sync/ for options.");
        }
        this.platform = Platform.findPlatform();
        this.boxStore = boxStore;
        this.url = url;
        this.credentials = credentials;
    }

    public SyncBuilder trustedCertificates(String[] paths) {
        this.trustedCertPaths = Arrays.copyOf(paths, paths.length);
        return this;
    }

    public SyncBuilder requestUpdatesMode(RequestUpdatesMode requestUpdatesMode) {
        this.requestUpdatesMode = requestUpdatesMode;
        return this;
    }

    public SyncBuilder uncommittedAcks() {
        this.uncommittedAcks = true;
        return this;
    }

    public SyncBuilder loginListener(SyncLoginListener loginListener) {
        this.loginListener = loginListener;
        return this;
    }

    public SyncBuilder completedListener(SyncCompletedListener completedListener) {
        this.completedListener = completedListener;
        return this;
    }

    public SyncBuilder changeListener(SyncChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SyncBuilder connectionListener(SyncConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this;
    }

    public SyncBuilder listener(SyncListener listener) {
        this.listener = listener;
        return this;
    }

    public SyncClient build() {
        if (this.boxStore.getSyncClient() != null) {
            throw new IllegalStateException("The given store is already associated with a Sync client, close it first.");
        }
        return new SyncClientImpl(this);
    }

    public SyncClient buildAndStart() {
        SyncClient syncClient = this.build();
        syncClient.start();
        return syncClient;
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static enum RequestUpdatesMode {
        MANUAL,
        AUTO,
        AUTO_NO_PUSHES;

    }
}

