/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.Cursor;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncClient;
import javax.annotation.Nullable;

@Internal
public class InternalAccess {
    public static <T> Cursor<T> getReader(Box<T> box) {
        return box.getReader();
    }

    public static long getHandle(BoxStore boxStore) {
        return boxStore.internalHandle();
    }

    public static long getHandle(Cursor reader) {
        return reader.internalHandle();
    }

    public static long getHandle(Transaction tx) {
        return tx.internalHandle();
    }

    public static void setSyncClient(BoxStore boxStore, @Nullable SyncClient syncClient) {
        boxStore.setSyncClient(syncClient);
    }

    public static <T> void releaseReader(Box<T> box, Cursor<T> reader) {
        box.releaseReader(reader);
    }

    public static <T> Cursor<T> getWriter(Box<T> box) {
        return box.getWriter();
    }

    public static <T> Cursor<T> getActiveTxCursor(Box<T> box) {
        return box.getActiveTxCursor();
    }

    public static <T> long getActiveTxCursorHandle(Box<T> box) {
        return box.getActiveTxCursor().internalHandle();
    }

    public static <T> void releaseWriter(Box<T> box, Cursor<T> writer) {
        box.releaseWriter(writer);
    }

    public static <T> void commitWriter(Box<T> box, Cursor<T> writer) {
        box.commitWriter(writer);
    }

    public static void enableCreationStackTracking() {
        Transaction.TRACK_CREATION_STACK = true;
        Cursor.TRACK_CREATION_STACK = true;
    }
}

