/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.sync.SyncClient;
import javax.annotation.Nullable;

public abstract class ConnectivityMonitor {
    @Nullable
    private SyncClient syncClient;

    void setObserver(SyncClient syncClient) {
        if (syncClient == null) {
            throw new IllegalArgumentException("Sync client must not be null");
        }
        this.syncClient = syncClient;
        this.onObserverSet();
    }

    void removeObserver() {
        this.syncClient = null;
        this.onObserverRemoved();
    }

    public void onObserverSet() {
    }

    public void onObserverRemoved() {
    }

    public final void notifyConnectionAvailable() {
        SyncClient syncClient = this.syncClient;
        if (syncClient != null) {
            syncClient.notifyConnectionAvailable();
        }
    }
}

