/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncCredentials;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.annotation.Nullable;

@Internal
public class SyncCredentialsToken
extends SyncCredentials {
    private final SyncCredentials.CredentialsType type;
    @Nullable
    private byte[] token;
    private volatile boolean cleared;

    SyncCredentialsToken(SyncCredentials.CredentialsType type) {
        this.type = type;
        this.token = null;
    }

    SyncCredentialsToken(SyncCredentials.CredentialsType type, byte[] token) {
        this(type);
        if (token == null || token.length == 0) {
            throw new IllegalArgumentException("Token must not be empty");
        }
        this.token = token;
    }

    SyncCredentialsToken(SyncCredentials.CredentialsType type, String token) {
        this(type, SyncCredentialsToken.asUtf8Bytes(token));
    }

    public long getTypeId() {
        return this.type.id;
    }

    @Nullable
    public byte[] getTokenBytes() {
        if (this.cleared) {
            throw new IllegalStateException("Credentials already have been cleared");
        }
        return this.token;
    }

    public void clear() {
        this.cleared = true;
        byte[] tokenToClear = this.token;
        if (tokenToClear != null) {
            Arrays.fill(tokenToClear, (byte)0);
        }
        this.token = null;
    }

    private static byte[] asUtf8Bytes(String token) {
        try {
            return token.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

