/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.query.QueryBuilder;
import io.objectbox.query.QueryConditionImpl;

abstract class LogicQueryCondition<T>
extends QueryConditionImpl<T> {
    private final QueryConditionImpl<T> leftCondition;
    private final QueryConditionImpl<T> rightCondition;

    LogicQueryCondition(QueryConditionImpl<T> leftCondition, QueryConditionImpl<T> rightCondition) {
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
    }

    @Override
    void apply(QueryBuilder<T> builder) {
        this.leftCondition.apply(builder);
        long leftConditionPointer = builder.internalGetLastCondition();
        this.rightCondition.apply(builder);
        long rightConditionPointer = builder.internalGetLastCondition();
        this.applyOperator(builder, leftConditionPointer, rightConditionPointer);
    }

    abstract void applyOperator(QueryBuilder<T> var1, long var2, long var4);

    static class OrCondition<T>
    extends LogicQueryCondition<T> {
        OrCondition(QueryConditionImpl<T> leftCondition, QueryConditionImpl<T> rightCondition) {
            super(leftCondition, rightCondition);
        }

        @Override
        void applyOperator(QueryBuilder<T> builder, long leftCondition, long rightCondition) {
            builder.internalOr(leftCondition, rightCondition);
        }
    }

    static class AndCondition<T>
    extends LogicQueryCondition<T> {
        AndCondition(QueryConditionImpl<T> leftCondition, QueryConditionImpl<T> rightCondition) {
            super(leftCondition, rightCondition);
        }

        @Override
        void applyOperator(QueryBuilder<T> builder, long leftCondition, long rightCondition) {
            builder.internalAnd(leftCondition, rightCondition);
        }
    }
}

