/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.model.IdUid;
import io.objectbox.model.Model;
import io.objectbox.model.ModelEntity;
import io.objectbox.model.ModelProperty;
import io.objectbox.model.ModelRelation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Internal
public class ModelBuilder {
    private static final int MODEL_VERSION = 2;
    final FlatBufferBuilder fbb = new FlatBufferBuilder();
    final List<Integer> entityOffsets = new ArrayList<Integer>();
    long version = 1L;
    Integer lastEntityId;
    Long lastEntityUid;
    Integer lastIndexId;
    Long lastIndexUid;
    Integer lastRelationId;
    Long lastRelationUid;

    int createVector(List<Integer> offsets) {
        int[] offsetArray = new int[offsets.size()];
        for (int i = 0; i < offsets.size(); ++i) {
            offsetArray[i] = offsets.get(i);
        }
        return this.fbb.createVectorOfTables(offsetArray);
    }

    public ModelBuilder version(long version) {
        this.version = version;
        return this;
    }

    public EntityBuilder entity(String name) {
        return new EntityBuilder(name);
    }

    public ModelBuilder lastEntityId(int lastEntityId, long lastEntityUid) {
        this.lastEntityId = lastEntityId;
        this.lastEntityUid = lastEntityUid;
        return this;
    }

    public ModelBuilder lastIndexId(int lastIndexId, long lastIndexUid) {
        this.lastIndexId = lastIndexId;
        this.lastIndexUid = lastIndexUid;
        return this;
    }

    public ModelBuilder lastRelationId(int lastRelationId, long lastRelationUid) {
        this.lastRelationId = lastRelationId;
        this.lastRelationUid = lastRelationUid;
        return this;
    }

    public byte[] build() {
        int idOffset;
        int nameOffset = this.fbb.createString("default");
        int entityVectorOffset = this.createVector(this.entityOffsets);
        Model.startModel(this.fbb);
        Model.addName(this.fbb, nameOffset);
        Model.addModelVersion(this.fbb, 2L);
        Model.addVersion(this.fbb, 1L);
        Model.addEntities(this.fbb, entityVectorOffset);
        if (this.lastEntityId != null) {
            idOffset = IdUid.createIdUid(this.fbb, this.lastEntityId.intValue(), this.lastEntityUid);
            Model.addLastEntityId(this.fbb, idOffset);
        }
        if (this.lastIndexId != null) {
            idOffset = IdUid.createIdUid(this.fbb, this.lastIndexId.intValue(), this.lastIndexUid);
            Model.addLastIndexId(this.fbb, idOffset);
        }
        if (this.lastRelationId != null) {
            idOffset = IdUid.createIdUid(this.fbb, this.lastRelationId.intValue(), this.lastRelationUid);
            Model.addLastRelationId(this.fbb, idOffset);
        }
        int offset = Model.endModel(this.fbb);
        this.fbb.finish(offset);
        return this.fbb.sizedByteArray();
    }

    public class EntityBuilder {
        final String name;
        final List<Integer> propertyOffsets = new ArrayList<Integer>();
        final List<Integer> relationOffsets = new ArrayList<Integer>();
        Integer id;
        Long uid;
        Integer flags;
        Integer lastPropertyId;
        Long lastPropertyUid;
        PropertyBuilder propertyBuilder;
        boolean finished;

        EntityBuilder(String name) {
            this.name = name;
        }

        public EntityBuilder id(int id, long uid) {
            this.checkNotFinished();
            this.id = id;
            this.uid = uid;
            return this;
        }

        public EntityBuilder lastPropertyId(int lastPropertyId, long lastPropertyUid) {
            this.checkNotFinished();
            this.lastPropertyId = lastPropertyId;
            this.lastPropertyUid = lastPropertyUid;
            return this;
        }

        public EntityBuilder flags(int flags) {
            this.flags = flags;
            return this;
        }

        private void checkNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("Already finished");
            }
        }

        public PropertyBuilder property(String name, int type) {
            return this.property(name, null, type);
        }

        public PropertyBuilder property(String name, @Nullable String targetEntityName, int type) {
            return this.property(name, targetEntityName, null, type);
        }

        public PropertyBuilder property(String name, @Nullable String targetEntityName, @Nullable String virtualTarget, int type) {
            this.checkNotFinished();
            this.checkFinishProperty();
            this.propertyBuilder = new PropertyBuilder(name, targetEntityName, virtualTarget, type);
            return this.propertyBuilder;
        }

        void checkFinishProperty() {
            if (this.propertyBuilder != null) {
                this.propertyOffsets.add(this.propertyBuilder.finish());
                this.propertyBuilder = null;
            }
        }

        public EntityBuilder relation(String name, int relationId, long relationUid, int targetEntityId, long targetEntityUid) {
            this.checkNotFinished();
            this.checkFinishProperty();
            int propertyNameOffset = ModelBuilder.this.fbb.createString(name);
            ModelRelation.startModelRelation(ModelBuilder.this.fbb);
            ModelRelation.addName(ModelBuilder.this.fbb, propertyNameOffset);
            int relationIdOffset = IdUid.createIdUid(ModelBuilder.this.fbb, relationId, relationUid);
            ModelRelation.addId(ModelBuilder.this.fbb, relationIdOffset);
            int targetEntityIdOffset = IdUid.createIdUid(ModelBuilder.this.fbb, targetEntityId, targetEntityUid);
            ModelRelation.addTargetEntityId(ModelBuilder.this.fbb, targetEntityIdOffset);
            this.relationOffsets.add(ModelRelation.endModelRelation(ModelBuilder.this.fbb));
            return this;
        }

        public ModelBuilder entityDone() {
            int idOffset;
            this.checkNotFinished();
            this.checkFinishProperty();
            this.finished = true;
            int testEntityNameOffset = ModelBuilder.this.fbb.createString(this.name);
            int propertiesOffset = ModelBuilder.this.createVector(this.propertyOffsets);
            int relationsOffset = this.relationOffsets.isEmpty() ? 0 : ModelBuilder.this.createVector(this.relationOffsets);
            ModelEntity.startModelEntity(ModelBuilder.this.fbb);
            ModelEntity.addName(ModelBuilder.this.fbb, testEntityNameOffset);
            ModelEntity.addProperties(ModelBuilder.this.fbb, propertiesOffset);
            if (relationsOffset != 0) {
                ModelEntity.addRelations(ModelBuilder.this.fbb, relationsOffset);
            }
            if (this.id != null && this.uid != null) {
                idOffset = IdUid.createIdUid(ModelBuilder.this.fbb, this.id.intValue(), this.uid);
                ModelEntity.addId(ModelBuilder.this.fbb, idOffset);
            }
            if (this.lastPropertyId != null) {
                idOffset = IdUid.createIdUid(ModelBuilder.this.fbb, this.lastPropertyId.intValue(), this.lastPropertyUid);
                ModelEntity.addLastPropertyId(ModelBuilder.this.fbb, idOffset);
            }
            if (this.flags != null) {
                ModelEntity.addFlags(ModelBuilder.this.fbb, this.flags.intValue());
            }
            ModelBuilder.this.entityOffsets.add(ModelEntity.endModelEntity(ModelBuilder.this.fbb));
            return ModelBuilder.this;
        }
    }

    public class PropertyBuilder {
        private final int type;
        private final int virtualTargetOffset;
        private final int propertyNameOffset;
        private final int targetEntityOffset;
        private int secondaryNameOffset;
        boolean finished;
        private int flags;
        private int id;
        private long uid;
        private int indexId;
        private long indexUid;
        private int indexMaxValueLength;

        PropertyBuilder(@Nullable String name, @Nullable String targetEntityName, String virtualTarget, int type) {
            this.type = type;
            this.propertyNameOffset = ModelBuilder.this.fbb.createString(name);
            this.targetEntityOffset = targetEntityName != null ? ModelBuilder.this.fbb.createString(targetEntityName) : 0;
            this.virtualTargetOffset = virtualTarget != null ? ModelBuilder.this.fbb.createString(virtualTarget) : 0;
        }

        public PropertyBuilder id(int id, long uid) {
            this.checkNotFinished();
            this.id = id;
            this.uid = uid;
            return this;
        }

        public PropertyBuilder indexId(int indexId, long indexUid) {
            this.checkNotFinished();
            this.indexId = indexId;
            this.indexUid = indexUid;
            return this;
        }

        public PropertyBuilder indexMaxValueLength(int indexMaxValueLength) {
            this.checkNotFinished();
            this.indexMaxValueLength = indexMaxValueLength;
            return this;
        }

        public PropertyBuilder flags(int flags) {
            this.checkNotFinished();
            this.flags = flags;
            return this;
        }

        public PropertyBuilder secondaryName(String secondaryName) {
            this.checkNotFinished();
            this.secondaryNameOffset = ModelBuilder.this.fbb.createString(secondaryName);
            return this;
        }

        private void checkNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("Already finished");
            }
        }

        public int finish() {
            this.checkNotFinished();
            this.finished = true;
            ModelProperty.startModelProperty(ModelBuilder.this.fbb);
            ModelProperty.addName(ModelBuilder.this.fbb, this.propertyNameOffset);
            if (this.targetEntityOffset != 0) {
                ModelProperty.addTargetEntity(ModelBuilder.this.fbb, this.targetEntityOffset);
            }
            if (this.virtualTargetOffset != 0) {
                ModelProperty.addVirtualTarget(ModelBuilder.this.fbb, this.virtualTargetOffset);
            }
            if (this.secondaryNameOffset != 0) {
                ModelProperty.addNameSecondary(ModelBuilder.this.fbb, this.secondaryNameOffset);
            }
            if (this.id != 0) {
                int idOffset = IdUid.createIdUid(ModelBuilder.this.fbb, this.id, this.uid);
                ModelProperty.addId(ModelBuilder.this.fbb, idOffset);
            }
            if (this.indexId != 0) {
                int indexIdOffset = IdUid.createIdUid(ModelBuilder.this.fbb, this.indexId, this.indexUid);
                ModelProperty.addIndexId(ModelBuilder.this.fbb, indexIdOffset);
            }
            if (this.indexMaxValueLength > 0) {
                ModelProperty.addMaxIndexValueLength(ModelBuilder.this.fbb, this.indexMaxValueLength);
            }
            ModelProperty.addType(ModelBuilder.this.fbb, this.type);
            if (this.flags != 0) {
                ModelProperty.addFlags(ModelBuilder.this.fbb, this.flags);
            }
            return ModelProperty.endModelProperty(ModelBuilder.this.fbb);
        }
    }
}

