/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.InternalAccess;
import io.objectbox.Property;
import io.objectbox.query.BreakForEach;
import io.objectbox.query.EagerRelation;
import io.objectbox.query.LazyList;
import io.objectbox.query.PropertyQuery;
import io.objectbox.query.QueryConsumer;
import io.objectbox.query.QueryFilter;
import io.objectbox.query.QueryPublisher;
import io.objectbox.reactive.DataSubscriptionList;
import io.objectbox.reactive.SubscriptionBuilder;
import io.objectbox.relation.RelationInfo;
import io.objectbox.relation.ToOne;
import java.io.Closeable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Query<T>
implements Closeable {
    final Box<T> box;
    private final BoxStore store;
    private final QueryPublisher<T> publisher;
    @Nullable
    private final List<EagerRelation<T, ?>> eagerRelations;
    @Nullable
    private final QueryFilter<T> filter;
    @Nullable
    private final Comparator<T> comparator;
    private final int queryAttempts;
    private static final int INITIAL_RETRY_BACK_OFF_IN_MS = 10;
    volatile long handle;

    native void nativeDestroy(long var1);

    native long nativeClone(long var1);

    native Object nativeFindFirst(long var1, long var3);

    native Object nativeFindUnique(long var1, long var3);

    native List<T> nativeFind(long var1, long var3, long var5, long var7) throws Exception;

    native long nativeFindFirstId(long var1, long var3);

    native long nativeFindUniqueId(long var1, long var3);

    native long[] nativeFindIds(long var1, long var3, long var5, long var7);

    native long nativeCount(long var1, long var3);

    native long nativeRemove(long var1, long var3);

    native String nativeToString(long var1);

    native String nativeDescribeParameters(long var1);

    native void nativeSetParameter(long var1, int var3, int var4, @Nullable String var5, String var6);

    private native void nativeSetParameters(long var1, int var3, int var4, @Nullable String var5, String var6, String var7);

    native void nativeSetParameter(long var1, int var3, int var4, @Nullable String var5, long var6);

    native void nativeSetParameters(long var1, int var3, int var4, @Nullable String var5, int[] var6);

    native void nativeSetParameters(long var1, int var3, int var4, @Nullable String var5, long[] var6);

    native void nativeSetParameters(long var1, int var3, int var4, @Nullable String var5, long var6, long var8);

    native void nativeSetParameter(long var1, int var3, int var4, @Nullable String var5, double var6);

    native void nativeSetParameters(long var1, int var3, int var4, @Nullable String var5, double var6, double var8);

    native void nativeSetParameters(long var1, int var3, int var4, @Nullable String var5, String[] var6);

    native void nativeSetParameter(long var1, int var3, int var4, @Nullable String var5, byte[] var6);

    Query(Box<T> box, long queryHandle, @Nullable List<EagerRelation<T, ?>> eagerRelations, @Nullable QueryFilter<T> filter, @Nullable Comparator<T> comparator) {
        this.box = box;
        this.store = box.getStore();
        this.queryAttempts = this.store.internalQueryAttempts();
        this.handle = queryHandle;
        this.publisher = new QueryPublisher<T>(this, box);
        this.eagerRelations = eagerRelations;
        this.filter = filter;
        this.comparator = comparator;
    }

    private Query(Query<T> originalQuery, long handle) {
        this(originalQuery.box, handle, originalQuery.eagerRelations, originalQuery.filter, originalQuery.comparator);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public synchronized void close() {
        if (this.handle != 0L) {
            long handleCopy = this.handle;
            this.handle = 0L;
            this.nativeDestroy(handleCopy);
        }
    }

    public Query<T> copy() {
        long cloneHandle = this.nativeClone(this.handle);
        return new Query<T>(this, cloneHandle);
    }

    long cursorHandle() {
        return InternalAccess.getActiveTxCursorHandle(this.box);
    }

    @Nullable
    public T findFirst() {
        this.ensureNoFilterNoComparator();
        return (T)this.callInReadTx(() -> {
            Object entity = this.nativeFindFirst(this.handle, this.cursorHandle());
            this.resolveEagerRelation(entity);
            return entity;
        });
    }

    private void ensureNoFilterNoComparator() {
        this.ensureNoFilter();
        this.ensureNoComparator();
    }

    private void ensureNoFilter() {
        if (this.filter != null) {
            throw new UnsupportedOperationException("Does not work with a filter. Only find() and forEach() support filters.");
        }
    }

    private void ensureNoComparator() {
        if (this.comparator != null) {
            throw new UnsupportedOperationException("Does not work with a sorting comparator. Only find() supports sorting with a comparator.");
        }
    }

    @Nullable
    public T findUnique() {
        this.ensureNoFilter();
        return (T)this.callInReadTx(() -> {
            Object entity = this.nativeFindUnique(this.handle, this.cursorHandle());
            this.resolveEagerRelation(entity);
            return entity;
        });
    }

    @Nonnull
    public List<T> find() {
        return this.callInReadTx(() -> {
            List<T> entities = this.nativeFind(this.handle, this.cursorHandle(), 0L, 0L);
            if (this.filter != null) {
                Iterator<T> iterator = entities.iterator();
                while (iterator.hasNext()) {
                    T entity = iterator.next();
                    if (this.filter.keep(entity)) continue;
                    iterator.remove();
                }
            }
            this.resolveEagerRelations(entities);
            if (this.comparator != null) {
                Collections.sort(entities, this.comparator);
            }
            return entities;
        });
    }

    @Nonnull
    public List<T> find(long offset, long limit) {
        this.ensureNoFilterNoComparator();
        return this.callInReadTx(() -> {
            List<T> entities = this.nativeFind(this.handle, this.cursorHandle(), offset, limit);
            this.resolveEagerRelations(entities);
            return entities;
        });
    }

    public long findFirstId() {
        this.checkOpen();
        return this.box.internalCallWithReaderHandle(cursorHandle -> this.nativeFindFirstId(this.handle, cursorHandle));
    }

    public long findUniqueId() {
        this.checkOpen();
        return this.box.internalCallWithReaderHandle(cursorHandle -> this.nativeFindUniqueId(this.handle, cursorHandle));
    }

    @Nonnull
    public long[] findIds() {
        return this.findIds(0L, 0L);
    }

    @Nonnull
    public long[] findIds(long offset, long limit) {
        this.checkOpen();
        return this.box.internalCallWithReaderHandle(cursorHandle -> this.nativeFindIds(this.handle, cursorHandle, offset, limit));
    }

    @Nonnull
    public LazyList<T> findLazy() {
        this.ensureNoFilterNoComparator();
        return new LazyList<T>(this.box, this.findIds(), false);
    }

    @Nonnull
    public LazyList<T> findLazyCached() {
        this.ensureNoFilterNoComparator();
        return new LazyList<T>(this.box, this.findIds(), true);
    }

    public PropertyQuery property(Property<T> property) {
        return new PropertyQuery(this, property);
    }

    <R> R callInReadTx(Callable<R> callable) {
        this.checkOpen();
        return this.store.callInReadTxWithRetry(callable, this.queryAttempts, 10, true);
    }

    public void forEach(QueryConsumer<T> consumer) {
        this.ensureNoComparator();
        this.checkOpen();
        this.box.getStore().runInReadTx(() -> {
            LazyList<T> lazyList = new LazyList<T>(this.box, this.findIds(), false);
            int size = lazyList.size();
            for (int i = 0; i < size; ++i) {
                T entity = lazyList.get(i);
                if (entity == null) {
                    throw new IllegalStateException("Internal error: data object was null");
                }
                if (this.filter != null && !this.filter.keep(entity)) continue;
                if (this.eagerRelations != null) {
                    this.resolveEagerRelationForNonNullEagerRelations(entity, i);
                }
                try {
                    consumer.accept(entity);
                    continue;
                }
                catch (BreakForEach breakForEach) {
                    break;
                }
            }
        });
    }

    void resolveEagerRelations(List<T> entities) {
        if (this.eagerRelations != null) {
            int entityIndex = 0;
            for (T entity : entities) {
                this.resolveEagerRelationForNonNullEagerRelations(entity, entityIndex);
                ++entityIndex;
            }
        }
    }

    void resolveEagerRelationForNonNullEagerRelations(@Nonnull T entity, int entityIndex) {
        for (EagerRelation<T, ?> eagerRelation : this.eagerRelations) {
            if (eagerRelation.limit != 0 && entityIndex >= eagerRelation.limit) continue;
            this.resolveEagerRelation(entity, eagerRelation);
        }
    }

    void resolveEagerRelation(@Nullable T entity) {
        if (this.eagerRelations != null && entity != null) {
            for (EagerRelation<T, ?> eagerRelation : this.eagerRelations) {
                this.resolveEagerRelation(entity, eagerRelation);
            }
        }
    }

    void resolveEagerRelation(@Nonnull T entity, EagerRelation<T, ?> eagerRelation) {
        if (this.eagerRelations != null) {
            RelationInfo relationInfo = eagerRelation.relationInfo;
            if (relationInfo.toOneGetter != null) {
                ToOne toOne = relationInfo.toOneGetter.getToOne(entity);
                if (toOne != null) {
                    toOne.getTarget();
                }
            } else {
                if (relationInfo.toManyGetter == null) {
                    throw new IllegalStateException("Relation info without relation getter: " + relationInfo);
                }
                List toMany = relationInfo.toManyGetter.getToMany(entity);
                if (toMany != null) {
                    toMany.size();
                }
            }
        }
    }

    public long count() {
        this.checkOpen();
        this.ensureNoFilter();
        return this.box.internalCallWithReaderHandle(cursorHandle -> this.nativeCount(this.handle, cursorHandle));
    }

    public Query<T> setParameter(Property<?> property, String value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, property.getEntityId(), property.getId(), null, value);
        return this;
    }

    public Query<T> setParameter(String alias, String value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, 0, 0, alias, value);
        return this;
    }

    public Query<T> setParameter(Property<?> property, long value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, property.getEntityId(), property.getId(), (String)null, value);
        return this;
    }

    public Query<T> setParameter(String alias, long value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, 0, 0, alias, value);
        return this;
    }

    public Query<T> setParameter(Property<?> property, double value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, property.getEntityId(), property.getId(), null, value);
        return this;
    }

    public Query<T> setParameter(String alias, double value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, 0, 0, alias, value);
        return this;
    }

    public Query<T> setParameter(Property<?> property, Date value) {
        return this.setParameter(property, value.getTime());
    }

    public Query<T> setParameter(String alias, Date value) {
        return this.setParameter(alias, value.getTime());
    }

    public Query<T> setParameter(Property<?> property, boolean value) {
        return this.setParameter(property, value ? 1L : 0L);
    }

    public Query<T> setParameter(String alias, boolean value) {
        return this.setParameter(alias, value ? 1L : 0L);
    }

    public Query<T> setParameters(Property<?> property, long value1, long value2) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, property.getEntityId(), property.getId(), (String)null, value1, value2);
        return this;
    }

    public Query<T> setParameters(String alias, long value1, long value2) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, 0, 0, alias, value1, value2);
        return this;
    }

    public Query<T> setParameters(Property<?> property, int[] values) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, property.getEntityId(), property.getId(), (String)null, values);
        return this;
    }

    public Query<T> setParameters(String alias, int[] values) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, 0, 0, alias, values);
        return this;
    }

    public Query<T> setParameters(Property<?> property, long[] values) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, property.getEntityId(), property.getId(), null, values);
        return this;
    }

    public Query<T> setParameters(String alias, long[] values) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, 0, 0, alias, values);
        return this;
    }

    public Query<T> setParameters(Property<?> property, double value1, double value2) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, property.getEntityId(), property.getId(), null, value1, value2);
        return this;
    }

    public Query<T> setParameters(String alias, double value1, double value2) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, 0, 0, alias, value1, value2);
        return this;
    }

    public Query<T> setParameters(Property<?> property, String[] values) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, property.getEntityId(), property.getId(), null, values);
        return this;
    }

    public Query<T> setParameters(String alias, String[] values) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, 0, 0, alias, values);
        return this;
    }

    public Query<T> setParameters(Property<?> property, String key, String value) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, property.getEntityId(), property.getId(), null, key, value);
        return this;
    }

    public Query<T> setParameters(String alias, String key, String value) {
        this.checkOpen();
        this.nativeSetParameters(this.handle, 0, 0, alias, key, value);
        return this;
    }

    public Query<T> setParameter(Property<?> property, byte[] value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, property.getEntityId(), property.getId(), null, value);
        return this;
    }

    public Query<T> setParameter(String alias, byte[] value) {
        this.checkOpen();
        this.nativeSetParameter(this.handle, 0, 0, alias, value);
        return this;
    }

    public long remove() {
        this.checkOpen();
        this.ensureNoFilter();
        return this.box.internalCallWithWriterHandle(cursorHandle -> this.nativeRemove(this.handle, cursorHandle));
    }

    public SubscriptionBuilder<List<T>> subscribe() {
        this.checkOpen();
        return new SubscriptionBuilder<List<T>>(this.publisher, null);
    }

    public SubscriptionBuilder<List<T>> subscribe(DataSubscriptionList dataSubscriptionList) {
        SubscriptionBuilder<List<T>> subscriptionBuilder = this.subscribe();
        subscriptionBuilder.dataSubscriptionList(dataSubscriptionList);
        return subscriptionBuilder;
    }

    public void publish() {
        this.publisher.publish();
    }

    public String describe() {
        this.checkOpen();
        return this.nativeToString(this.handle);
    }

    public String describeParameters() {
        this.checkOpen();
        return this.nativeDescribeParameters(this.handle);
    }

    private void checkOpen() {
        if (this.handle == 0L) {
            throw new IllegalStateException("This query is closed. Build and use a new one.");
        }
    }
}

