/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.BoxStore;
import io.objectbox.Cursor;
import io.objectbox.EntityInfo;
import io.objectbox.Property;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Beta;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.DbException;
import io.objectbox.internal.CallWithHandle;
import io.objectbox.internal.IdGetter;
import io.objectbox.internal.ReflectionCache;
import io.objectbox.query.QueryBuilder;
import io.objectbox.query.QueryCondition;
import io.objectbox.relation.RelationInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Box<T> {
    private final BoxStore store;
    private final Class<T> entityClass;
    final ThreadLocal<Cursor<T>> activeTxCursor = new ThreadLocal();
    private final ThreadLocal<Cursor<T>> threadLocalReader = new ThreadLocal();
    private final IdGetter<T> idGetter;
    private EntityInfo<T> entityInfo;
    private volatile Field boxStoreField;

    Box(BoxStore store, Class<T> entityClass) {
        this.store = store;
        this.entityClass = entityClass;
        this.idGetter = store.getEntityInfo(entityClass).getIdGetter();
    }

    Cursor<T> getReader() {
        Cursor<T> cursor = this.getActiveTxCursor();
        if (cursor != null) {
            return cursor;
        }
        cursor = this.threadLocalReader.get();
        if (cursor != null) {
            Transaction tx = cursor.tx;
            if (tx.isClosed() || !tx.isRecycled()) {
                throw new IllegalStateException("Illegal reader TX state");
            }
            tx.renew();
            cursor.renew();
        } else {
            cursor = this.store.beginReadTx().createCursor(this.entityClass);
            this.threadLocalReader.set(cursor);
        }
        return cursor;
    }

    Cursor<T> getActiveTxCursor() {
        Transaction activeTx = this.store.activeTx.get();
        if (activeTx != null) {
            if (activeTx.isClosed()) {
                throw new IllegalStateException("Active TX is closed");
            }
            Cursor<T> cursor = this.activeTxCursor.get();
            if (cursor == null || cursor.getTx().isClosed()) {
                cursor = activeTx.createCursor(this.entityClass);
                this.activeTxCursor.set(cursor);
            }
            return cursor;
        }
        return null;
    }

    Cursor<T> getWriter() {
        Cursor<T> cursor = this.getActiveTxCursor();
        if (cursor != null) {
            return cursor;
        }
        Transaction tx = this.store.beginTx();
        try {
            return tx.createCursor(this.entityClass);
        }
        catch (RuntimeException e) {
            tx.close();
            throw e;
        }
    }

    void commitWriter(Cursor<T> cursor) {
        if (this.activeTxCursor.get() == null) {
            cursor.close();
            cursor.getTx().commitAndClose();
        }
    }

    void releaseWriter(Cursor<T> cursor) {
        Transaction tx;
        if (this.activeTxCursor.get() == null && !(tx = cursor.getTx()).isClosed()) {
            cursor.close();
            tx.abort();
            tx.close();
        }
    }

    void releaseReader(Cursor<T> cursor) {
        if (this.activeTxCursor.get() == null) {
            Transaction tx = cursor.getTx();
            if (tx.isClosed() || tx.isRecycled() || !tx.isReadOnly()) {
                throw new IllegalStateException("Illegal reader TX state");
            }
            tx.recycle();
        }
    }

    public void closeThreadResources() {
        Cursor<T> cursor = this.threadLocalReader.get();
        if (cursor != null) {
            cursor.close();
            cursor.getTx().close();
            this.threadLocalReader.remove();
        }
    }

    void txCommitted(Transaction tx) {
        Cursor<T> cursor = this.activeTxCursor.get();
        if (cursor != null) {
            this.activeTxCursor.remove();
            cursor.close();
        }
    }

    void readTxFinished(Transaction tx) {
        Cursor<T> cursor = this.activeTxCursor.get();
        if (cursor != null && cursor.getTx() == tx) {
            this.activeTxCursor.remove();
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPropertyId(String propertyName) {
        Cursor<T> reader = this.getReader();
        try {
            int n = reader.getPropertyId(propertyName);
            return n;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    @Internal
    public long getId(T entity) {
        return this.idGetter.getId(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long id) {
        Cursor<T> reader = this.getReader();
        try {
            T t = reader.get(id);
            return t;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(Iterable<Long> ids) {
        ArrayList<T> list = new ArrayList<T>();
        Cursor<T> reader = this.getReader();
        try {
            for (Long id : ids) {
                T entity = reader.get(id);
                if (entity == null) continue;
                list.add(entity);
            }
        }
        finally {
            this.releaseReader(reader);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(long[] ids) {
        ArrayList<T> list = new ArrayList<T>(ids.length);
        Cursor<T> reader = this.getReader();
        try {
            long[] lArray = ids;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long id = lArray[i];
                T entity = reader.get(id);
                if (entity == null) continue;
                list.add(entity);
            }
        }
        finally {
            this.releaseReader(reader);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, T> getMap(Iterable<Long> ids) {
        HashMap<Long, T> map = new HashMap<Long, T>();
        Cursor<T> reader = this.getReader();
        try {
            for (Long id : ids) {
                map.put(id, reader.get(id));
            }
        }
        finally {
            this.releaseReader(reader);
        }
        return map;
    }

    public long count() {
        return this.count(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(long maxCount) {
        Cursor<T> reader = this.getReader();
        try {
            long l = reader.count(maxCount);
            return l;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    public boolean isEmpty() {
        return this.count(1L) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll() {
        ArrayList<T> list = new ArrayList<T>();
        Cursor<T> cursor = this.getReader();
        try {
            T object = cursor.first();
            while (object != null) {
                list.add(object);
                object = cursor.next();
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            this.releaseReader(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long id) {
        Cursor<T> reader = this.getReader();
        try {
            boolean bl = reader.seek(id);
            return bl;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(T entity) {
        Cursor<T> cursor = this.getWriter();
        try {
            long key = cursor.put(entity);
            this.commitWriter(cursor);
            long l = key;
            return l;
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final void put(T ... entities) {
        if (entities == null || entities.length == 0) {
            return;
        }
        Cursor<T> cursor = this.getWriter();
        try {
            for (T entity : entities) {
                cursor.put(entity);
            }
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@Nullable Collection<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        Cursor<T> cursor = this.getWriter();
        try {
            for (T entity : entities) {
                cursor.put(entity);
            }
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBatched(@Nullable Collection<T> entities, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("Batch size must be 1 or greater but was " + batchSize);
        }
        if (entities == null) {
            return;
        }
        Iterator<T> iterator = entities.iterator();
        while (iterator.hasNext()) {
            Cursor<T> cursor = this.getWriter();
            try {
                int number = 0;
                while (number++ < batchSize && iterator.hasNext()) {
                    cursor.put(iterator.next());
                }
                this.commitWriter(cursor);
            }
            finally {
                this.releaseWriter(cursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long id) {
        boolean removed;
        Cursor<T> cursor = this.getWriter();
        try {
            removed = cursor.deleteEntity(id);
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long ... ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        Cursor<T> cursor = this.getWriter();
        try {
            for (long key : ids) {
                cursor.deleteEntity(key);
            }
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    @Deprecated
    public void removeByKeys(@Nullable Collection<Long> ids) {
        this.removeByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByIds(@Nullable Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        Cursor<T> cursor = this.getWriter();
        try {
            for (long key : ids) {
                cursor.deleteEntity(key);
            }
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T object) {
        boolean removed;
        Cursor<T> cursor = this.getWriter();
        try {
            long id = cursor.getId(object);
            removed = cursor.deleteEntity(id);
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final void remove(T ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        Cursor<T> cursor = this.getWriter();
        try {
            for (T entity : objects) {
                long key = cursor.getId(entity);
                cursor.deleteEntity(key);
            }
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nullable Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        Cursor<T> cursor = this.getWriter();
        try {
            for (T entity : objects) {
                long key = cursor.getId(entity);
                cursor.deleteEntity(key);
            }
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    public void removeAll() {
        Cursor<T> cursor = this.getWriter();
        try {
            cursor.deleteAll();
            this.commitWriter(cursor);
        }
        finally {
            this.releaseWriter(cursor);
        }
    }

    @Experimental
    public long panicModeRemoveAll() {
        return this.store.panicModeRemoveAllObjects(this.getEntityInfo().getEntityId());
    }

    @Deprecated
    public QueryBuilder<T> query() {
        return new QueryBuilder(this, this.store.getNativeStore(), this.store.getDbName(this.entityClass));
    }

    public QueryBuilder<T> query(QueryCondition<T> queryCondition) {
        return this.query().apply(queryCondition);
    }

    public BoxStore getStore() {
        return this.store;
    }

    public synchronized EntityInfo<T> getEntityInfo() {
        if (this.entityInfo == null) {
            Cursor<T> reader = this.getReader();
            try {
                this.entityInfo = reader.getEntityInfo();
            }
            finally {
                this.releaseReader(reader);
            }
        }
        return this.entityInfo;
    }

    @Beta
    public void attach(T entity) {
        if (this.boxStoreField == null) {
            try {
                this.boxStoreField = ReflectionCache.getInstance().getField(this.entityClass, "__boxStore");
            }
            catch (Exception e) {
                throw new DbException("Entity cannot be attached - only active entities with relationships support attaching (class has no __boxStore field(?)) : " + this.entityClass, e);
            }
        }
        try {
            this.boxStoreField.set(entity, this.store);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isChanged(T entity) {
        return false;
    }

    private boolean putIfChanged(T entity) {
        return false;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public List<T> internalGetBacklinkEntities(int entityId, Property<?> relationIdProperty, long key) {
        Cursor<T> reader = this.getReader();
        try {
            List<T> list = reader.getBacklinkEntities(entityId, relationIdProperty, key);
            return list;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public List<T> internalGetRelationEntities(int sourceEntityId, int relationId, long key, boolean backlink) {
        Cursor<T> reader = this.getReader();
        try {
            List<T> list = reader.getRelationEntities(sourceEntityId, relationId, key, backlink);
            return list;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public long[] internalGetRelationIds(int sourceEntityId, int relationId, long key, boolean backlink) {
        Cursor<T> reader = this.getReader();
        try {
            long[] lArray = reader.getRelationIds(sourceEntityId, relationId, key, backlink);
            return lArray;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    public List<T> getRelationEntities(RelationInfo<?, T> relationInfo, long id) {
        return this.internalGetRelationEntities(relationInfo.sourceInfo.getEntityId(), relationInfo.relationId, id, false);
    }

    public List<T> getRelationBacklinkEntities(RelationInfo<T, ?> relationInfo, long id) {
        return this.internalGetRelationEntities(relationInfo.sourceInfo.getEntityId(), relationInfo.relationId, id, true);
    }

    public long[] getRelationIds(RelationInfo<?, T> relationInfo, long id) {
        return this.internalGetRelationIds(relationInfo.sourceInfo.getEntityId(), relationInfo.relationId, id, false);
    }

    public long[] getRelationBacklinkIds(RelationInfo<T, ?> relationInfo, long id) {
        return this.internalGetRelationIds(relationInfo.sourceInfo.getEntityId(), relationInfo.relationId, id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public <RESULT> RESULT internalCallWithReaderHandle(CallWithHandle<RESULT> task) {
        Cursor<T> reader = this.getReader();
        try {
            RESULT RESULT = task.call(reader.internalHandle());
            return RESULT;
        }
        finally {
            this.releaseReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public <RESULT> RESULT internalCallWithWriterHandle(CallWithHandle<RESULT> task) {
        RESULT result;
        Cursor<T> writer = this.getWriter();
        try {
            result = task.call(writer.internalHandle());
            this.commitWriter(writer);
        }
        finally {
            this.releaseWriter(writer);
        }
        return result;
    }

    public String getReaderDebugInfo() {
        Cursor<T> reader = this.getReader();
        try {
            String string = reader + " with " + reader.getTx() + "; store's commit count: " + this.getStore().commitCount;
            return string;
        }
        finally {
            this.releaseReader(reader);
        }
    }
}

