/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.Cursor;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncClient;
import javax.annotation.Nullable;

@Internal
public class InternalAccess {
    public static Transaction getActiveTx(BoxStore boxStore) {
        Transaction tx = boxStore.activeTx.get();
        if (tx == null) {
            throw new IllegalStateException("No active transaction");
        }
        tx.checkOpen();
        return tx;
    }

    public static long getHandle(Transaction tx) {
        return tx.internalHandle();
    }

    public static void setSyncClient(BoxStore boxStore, @Nullable SyncClient syncClient) {
        boxStore.setSyncClient(syncClient);
    }

    public static <T> Cursor<T> getWriter(Box<T> box) {
        return box.getWriter();
    }

    public static <T> Cursor<T> getActiveTxCursor(Box<T> box) {
        return box.getActiveTxCursor();
    }

    public static <T> long getActiveTxCursorHandle(Box<T> box) {
        return box.getActiveTxCursor().internalHandle();
    }

    public static <T> void commitWriter(Box<T> box, Cursor<T> writer) {
        box.commitWriter(writer);
    }

    public static void enableCreationStackTracking() {
        Transaction.TRACK_CREATION_STACK = true;
        Cursor.TRACK_CREATION_STACK = true;
    }
}

