/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncCredentials;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nullable;

@Internal
public final class SyncCredentialsToken
extends SyncCredentials {
    @Nullable
    private byte[] token = null;
    private volatile boolean cleared;

    SyncCredentialsToken(SyncCredentials.CredentialsType type) {
        super(type);
    }

    SyncCredentialsToken(SyncCredentials.CredentialsType type, byte[] token) {
        this(type);
        if (token == null || token.length == 0) {
            throw new IllegalArgumentException("Token must not be empty");
        }
        this.token = token;
    }

    SyncCredentialsToken(SyncCredentials.CredentialsType type, String token) {
        this(type, token.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public byte[] getTokenBytes() {
        if (this.cleared) {
            throw new IllegalStateException("Credentials already have been cleared");
        }
        return this.token;
    }

    public void clear() {
        this.cleared = true;
        byte[] tokenToClear = this.token;
        if (tokenToClear != null) {
            Arrays.fill(tokenToClear, (byte)0);
        }
        this.token = null;
    }
}

