/*
 * Copyright 2024 ObjectBox Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.model;

/**
 * Not really an enum, but binary flags to use across languages
 */
@SuppressWarnings("unused")
public final class EntityFlags {
  private EntityFlags() { }
  /**
   * Use the default (no arguments) constructor to create entities
   */
  public static final int USE_NO_ARG_CONSTRUCTOR = 1;
  /**
   * Enable "data synchronization" for this entity type: objects will be synced with other stores over the network.
   * It's possible to have local-only (non-synced) types and synced types in the same store (schema/data model).
   */
  public static final int SYNC_ENABLED = 2;
  /**
   * Makes object IDs for a synced types (SYNC_ENABLED is set) global.
   * By default (not using this flag), the 64 bit object IDs have a local scope and are not unique globally.
   * This flag tells ObjectBox to treat object IDs globally and thus no ID mapping (local <-> global) is performed.
   * Often this is used with assignable IDs (ID_SELF_ASSIGNABLE property flag is set) and some special ID scheme.
   * Note: typically you won't do this with automatically assigned IDs, set by the local ObjectBox store.
   *       Two devices would likely overwrite each other's object during sync as object IDs are prone to collide.
   *       It might be OK if you can somehow ensure that only a single device will create new IDs.
   */
  public static final int SHARED_GLOBAL_IDS = 4;
}

