/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Box;
import io.objectbox.exception.DbException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class LazyList<E>
implements List<E> {
    private final Box<E> box;
    private final long[] objectIds;
    private final List<E> entities;
    final int size;
    private volatile int loadedCount;

    LazyList(Box<E> box, long[] objectIds, boolean cacheEntities) {
        if (box == null || objectIds == null) {
            throw new NullPointerException("Illegal null parameters passed");
        }
        this.box = box;
        this.objectIds = objectIds;
        this.size = objectIds.length;
        if (cacheEntities) {
            this.entities = new ArrayList(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.entities.add(null);
            }
        } else {
            this.entities = null;
        }
    }

    public void loadRemaining() {
        if (this.loadedCount != this.size) {
            this.checkCached();
            this.box.getStore().runInReadTx(() -> {
                for (int i = 0; i < this.size; ++i) {
                    this.get(i);
                }
            });
        }
    }

    protected void checkCached() {
        if (this.entities == null) {
            throw new DbException("This operation only works with cached lazy lists");
        }
    }

    public E peek(int location) {
        if (this.entities != null) {
            return this.entities.get(location);
        }
        return null;
    }

    public int getLoadedCount() {
        return this.loadedCount;
    }

    public boolean isLoadedCompletely() {
        return this.loadedCount == this.size;
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends E> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        this.loadRemaining();
        return this.entities.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.loadRemaining();
        return this.entities.containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public E get(int location) {
        if (location < 0 || location > this.size) {
            throw new IndexOutOfBoundsException("Illegal cursor location " + location);
        }
        if (this.entities != null) {
            E entity = this.entities.get(location);
            if (entity == null) {
                E newEntity = this.box.get(this.objectIds[location]);
                LazyList lazyList = this;
                synchronized (lazyList) {
                    entity = this.entities.get(location);
                    if (entity == null) {
                        entity = newEntity;
                        this.entities.set(location, newEntity);
                        ++this.loadedCount;
                    }
                }
            }
            return entity;
        }
        LazyList lazyList = this;
        synchronized (lazyList) {
            return this.box.get(this.objectIds[location]);
        }
    }

    @Override
    public int indexOf(Object object) {
        this.loadRemaining();
        return this.entities.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new LazyIterator(0);
    }

    @Override
    public int lastIndexOf(Object object) {
        this.loadRemaining();
        return this.entities.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new LazyIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new LazyIterator(location);
    }

    @Override
    public E remove(int location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<E> subList(int start, int end) {
        this.checkCached();
        for (int i = start; i < end; ++i) {
            this.get(i);
        }
        return this.entities.subList(start, end);
    }

    @Override
    public Object[] toArray() {
        this.loadRemaining();
        return this.entities.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.loadRemaining();
        return this.entities.toArray(array);
    }

    protected class LazyIterator
    implements ListIterator<E> {
        private int index;

        public LazyIterator(int startLocation) {
            this.index = startLocation;
        }

        @Override
        public void add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return LazyList.this.get(this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < LazyList.this.size;
        }

        @Override
        public E next() {
            if (this.index >= LazyList.this.size) {
                throw new NoSuchElementException();
            }
            Object entity = LazyList.this.get(this.index);
            ++this.index;
            return entity;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

