/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.InternalAccess;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.ConnectivityMonitor;
import io.objectbox.sync.ObjectsMessageBuilder;
import io.objectbox.sync.SyncBuilder;
import io.objectbox.sync.SyncClient;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.SyncCredentialsToken;
import io.objectbox.sync.SyncCredentialsUserPassword;
import io.objectbox.sync.SyncState;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.listener.SyncCompletedListener;
import io.objectbox.sync.listener.SyncConnectionListener;
import io.objectbox.sync.listener.SyncListener;
import io.objectbox.sync.listener.SyncLoginListener;
import io.objectbox.sync.listener.SyncTimeListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Internal
public class SyncClientImpl
implements SyncClient {
    @Nullable
    private BoxStore boxStore;
    private final String serverUrl;
    private final InternalSyncClientListener internalListener;
    @Nullable
    private final ConnectivityMonitor connectivityMonitor;
    private volatile long handle;
    @Nullable
    private volatile SyncLoginListener loginListener;
    @Nullable
    private volatile SyncCompletedListener completedListener;
    @Nullable
    private volatile SyncConnectionListener connectionListener;
    @Nullable
    private volatile SyncTimeListener timeListener;
    private volatile long lastLoginCode;
    private volatile boolean started;

    SyncClientImpl(SyncBuilder builder) {
        this.boxStore = builder.boxStore;
        this.serverUrl = builder.url;
        this.connectivityMonitor = builder.platform.getConnectivityMonitor();
        long boxStoreHandle = builder.boxStore.getNativeStore();
        long handle = SyncClientImpl.nativeCreate(boxStoreHandle, this.serverUrl, builder.trustedCertPaths);
        if (handle == 0L) {
            throw new RuntimeException("Failed to create sync client: handle is zero.");
        }
        this.handle = handle;
        if (builder.requestUpdatesMode != SyncBuilder.RequestUpdatesMode.AUTO) {
            boolean autoRequestUpdates = builder.requestUpdatesMode != SyncBuilder.RequestUpdatesMode.MANUAL;
            this.nativeSetRequestUpdatesMode(handle, autoRequestUpdates, false);
        }
        if (builder.uncommittedAcks) {
            this.nativeSetUncommittedAcks(handle, true);
        }
        if (builder.listener != null) {
            this.setSyncListener(builder.listener);
        } else {
            this.loginListener = builder.loginListener;
            this.completedListener = builder.completedListener;
            if (builder.changeListener != null) {
                this.setSyncChangeListener(builder.changeListener);
            }
            this.connectionListener = builder.connectionListener;
            this.timeListener = builder.timeListener;
        }
        this.internalListener = new InternalSyncClientListener();
        this.nativeSetListener(handle, this.internalListener);
        this.setLoginCredentials(builder.credentials);
        InternalAccess.setSyncClient(builder.boxStore, this);
    }

    private long getHandle() {
        long handle = this.handle;
        if (handle == 0L) {
            throw new IllegalStateException("SyncClient already closed");
        }
        return handle;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public long getLastLoginCode() {
        return this.lastLoginCode;
    }

    @Override
    public boolean isLoggedIn() {
        return this.lastLoginCode == 20L;
    }

    @Override
    public long getServerTimeNanos() {
        return this.nativeServerTime(this.getHandle());
    }

    @Override
    public long getServerTimeDiffNanos() {
        return this.nativeServerTimeDiff(this.getHandle());
    }

    @Override
    public long getRoundtripTimeNanos() {
        return this.nativeRoundtripTime(this.getHandle());
    }

    public SyncState getSyncState() {
        return SyncState.fromId(this.nativeGetState(this.getHandle()));
    }

    @Override
    public void setSyncLoginListener(@Nullable SyncLoginListener listener) {
        this.loginListener = listener;
    }

    @Override
    public void setSyncCompletedListener(@Nullable SyncCompletedListener listener) {
        this.completedListener = listener;
    }

    @Override
    public void setSyncChangeListener(@Nullable SyncChangeListener changesListener) {
        this.nativeSetSyncChangesListener(this.getHandle(), changesListener);
    }

    @Override
    public void setSyncTimeListener(@Nullable SyncTimeListener timeListener) {
        this.timeListener = timeListener;
    }

    @Override
    public void setSyncConnectionListener(@Nullable SyncConnectionListener listener) {
        this.connectionListener = listener;
    }

    @Override
    public void setSyncListener(@Nullable SyncListener listener) {
        this.loginListener = listener;
        this.completedListener = listener;
        this.timeListener = listener;
        this.connectionListener = listener;
        this.setSyncChangeListener(listener);
    }

    @Override
    public void setLoginCredentials(SyncCredentials credentials) {
        if (credentials instanceof SyncCredentialsToken) {
            SyncCredentialsToken credToken = (SyncCredentialsToken)credentials;
            this.nativeSetLoginInfo(this.getHandle(), credToken.getTypeId(), credToken.getTokenBytes());
            credToken.clear();
        } else if (credentials instanceof SyncCredentialsUserPassword) {
            SyncCredentialsUserPassword credUserPassword = (SyncCredentialsUserPassword)credentials;
            this.nativeSetLoginInfoUserPassword(this.getHandle(), credUserPassword.getTypeId(), credUserPassword.getUsername(), credUserPassword.getPassword());
        } else {
            throw new IllegalArgumentException("credentials is not a supported type");
        }
    }

    @Override
    public boolean awaitFirstLogin(long millisToWait) {
        if (!this.started) {
            this.start();
        }
        return this.internalListener.awaitFirstLogin(millisToWait);
    }

    @Override
    public synchronized void start() {
        this.nativeStart(this.getHandle());
        this.started = true;
        if (this.connectivityMonitor != null) {
            this.connectivityMonitor.setObserver(this);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void stop() {
        if (this.connectivityMonitor != null) {
            this.connectivityMonitor.removeObserver();
        }
        this.nativeStop(this.getHandle());
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        long handleToDelete;
        SyncClientImpl syncClientImpl = this;
        synchronized (syncClientImpl) {
            BoxStore boxStore;
            if (this.connectivityMonitor != null) {
                this.connectivityMonitor.removeObserver();
            }
            if ((boxStore = this.boxStore) != null) {
                SyncClient syncClient = boxStore.getSyncClient();
                if (syncClient == this) {
                    InternalAccess.setSyncClient(boxStore, null);
                }
                this.boxStore = null;
            }
            handleToDelete = this.handle;
            this.handle = 0L;
        }
        if (handleToDelete != 0L) {
            this.nativeDelete(handleToDelete);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    @Experimental
    public boolean requestFullSync() {
        return this.nativeRequestFullSync(this.getHandle(), false);
    }

    @Experimental
    public boolean requestFullSyncAndUpdates() {
        return this.nativeRequestFullSync(this.getHandle(), true);
    }

    @Override
    public boolean requestUpdates() {
        return this.nativeRequestUpdates(this.getHandle(), true);
    }

    @Override
    public boolean requestUpdatesOnce() {
        return this.nativeRequestUpdates(this.getHandle(), false);
    }

    @Override
    public boolean cancelUpdates() {
        return this.nativeCancelUpdates(this.getHandle());
    }

    @Override
    public void notifyConnectionAvailable() {
        this.nativeTriggerReconnect(this.getHandle());
    }

    @Override
    public ObjectsMessageBuilder startObjectsMessage(long flags, @Nullable String topic) {
        return new ObjectsMessageBuilderImpl(this, flags, topic);
    }

    private static native long nativeCreate(long var0, String var2, @Nullable String[] var3);

    private native void nativeDelete(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native void nativeSetLoginInfo(long var1, long var3, @Nullable byte[] var5);

    private native void nativeSetLoginInfoUserPassword(long var1, long var3, String var5, String var6);

    private native void nativeSetListener(long var1, @Nullable InternalSyncClientListener var3);

    private native void nativeSetSyncChangesListener(long var1, @Nullable SyncChangeListener var3);

    private native void nativeSetRequestUpdatesMode(long var1, boolean var3, boolean var4);

    private native void nativeSetUncommittedAcks(long var1, boolean var3);

    private native int nativeGetState(long var1);

    private native boolean nativeRequestUpdates(long var1, boolean var3);

    private native boolean nativeRequestFullSync(long var1, boolean var3);

    private native boolean nativeCancelUpdates(long var1);

    private native boolean nativeTriggerReconnect(long var1);

    private native long nativeServerTime(long var1);

    private native long nativeServerTimeDiff(long var1);

    private native long nativeRoundtripTime(long var1);

    private native long nativeObjectsMessageStart(long var1, @Nullable String var3);

    private native void nativeObjectsMessageAddString(long var1, long var3, String var5);

    private native void nativeObjectsMessageAddBytes(long var1, long var3, byte[] var5, boolean var6);

    private native boolean nativeObjectsMessageSend(long var1, long var3);

    private class InternalSyncClientListener {
        private final CountDownLatch firstLoginLatch = new CountDownLatch(1);

        private InternalSyncClientListener() {
        }

        public void onLogin() {
            SyncClientImpl.this.lastLoginCode = 20L;
            this.firstLoginLatch.countDown();
            SyncLoginListener listenerToFire = SyncClientImpl.this.loginListener;
            if (listenerToFire != null) {
                listenerToFire.onLoggedIn();
            }
        }

        public void onLoginFailure(long errorCode) {
            SyncClientImpl.this.lastLoginCode = errorCode;
            this.firstLoginLatch.countDown();
            SyncLoginListener listenerToFire = SyncClientImpl.this.loginListener;
            if (listenerToFire != null) {
                listenerToFire.onLoginFailed(errorCode);
            }
        }

        public void onSyncComplete() {
            SyncCompletedListener listenerToFire = SyncClientImpl.this.completedListener;
            if (listenerToFire != null) {
                listenerToFire.onUpdatesCompleted();
            }
        }

        public void onServerTimeUpdate(long serverTimeNanos) {
            SyncTimeListener listenerToFire = SyncClientImpl.this.timeListener;
            if (listenerToFire != null) {
                listenerToFire.onServerTimeUpdate(serverTimeNanos);
            }
        }

        public void onDisconnect() {
            SyncConnectionListener listenerToFire = SyncClientImpl.this.connectionListener;
            if (listenerToFire != null) {
                listenerToFire.onDisconnected();
            }
        }

        boolean awaitFirstLogin(long millisToWait) {
            try {
                return this.firstLoginLatch.await(millisToWait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    public static class ObjectsMessageBuilderImpl
    implements ObjectsMessageBuilder {
        private boolean sent;
        private final long builderHandle;
        private final SyncClientImpl syncClient;

        private ObjectsMessageBuilderImpl(SyncClientImpl syncClient, long flags, @Nullable String topic) {
            this.syncClient = syncClient;
            this.builderHandle = syncClient.nativeObjectsMessageStart(flags, topic);
        }

        @Override
        public ObjectsMessageBuilderImpl addString(long optionalId, String value) {
            this.checkNotSent();
            this.syncClient.nativeObjectsMessageAddString(this.builderHandle, optionalId, value);
            return this;
        }

        @Override
        public ObjectsMessageBuilderImpl addBytes(long optionalId, byte[] value, boolean isFlatBuffers) {
            this.checkNotSent();
            this.syncClient.nativeObjectsMessageAddBytes(this.builderHandle, optionalId, value, isFlatBuffers);
            return this;
        }

        @Override
        public boolean send() {
            if (!this.syncClient.isStarted()) {
                return false;
            }
            this.checkNotSent();
            this.sent = true;
            return this.syncClient.nativeObjectsMessageSend(this.syncClient.getHandle(), this.builderHandle);
        }

        private void checkNotSent() {
            if (this.sent) {
                throw new IllegalStateException("Already sent this message, start a new one instead.");
            }
        }
    }
}

