/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.converter;

import io.objectbox.converter.PropertyConverter;
import io.objectbox.flatbuffers.ArrayReadWriteBuf;
import io.objectbox.flatbuffers.FlexBuffers;
import io.objectbox.flatbuffers.FlexBuffersBuilder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class StringMapConverter
implements PropertyConverter<Map<String, String>, byte[]> {
    private static final AtomicReference<FlexBuffersBuilder> cachedBuilder = new AtomicReference();

    public byte[] convertToDatabaseValue(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        FlexBuffersBuilder builder = cachedBuilder.getAndSet(null);
        if (builder == null) {
            builder = new FlexBuffersBuilder(new ArrayReadWriteBuf(512), 3);
        }
        int mapStart = builder.startMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Map keys or values must not be null");
            }
            builder.putString(entry.getKey(), entry.getValue());
        }
        builder.endMap(null, mapStart);
        ByteBuffer buffer = builder.finish();
        byte[] out = new byte[buffer.limit()];
        buffer.get(out);
        if (buffer.limit() <= 262144) {
            builder.clear();
            cachedBuilder.getAndSet(builder);
        }
        return out;
    }

    public Map<String, String> convertToEntityProperty(byte[] databaseValue) {
        if (databaseValue == null) {
            return null;
        }
        FlexBuffers.Map map = FlexBuffers.getRoot(new ArrayReadWriteBuf(databaseValue, databaseValue.length)).asMap();
        int entryCount = map.size();
        FlexBuffers.KeyVector keys = map.keys();
        FlexBuffers.Vector values = map.values();
        HashMap<String, String> resultMap = new HashMap<String, String>((int)((double)entryCount / 0.75 + 1.0));
        for (int i = 0; i < entryCount; ++i) {
            String key = keys.get(i).toString();
            String value = values.get(i).asString();
            resultMap.put(key, value);
        }
        return resultMap;
    }
}

