/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync.server;

import io.objectbox.flatbuffers.BaseVector;
import io.objectbox.flatbuffers.Constants;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class JwtConfig
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static JwtConfig getRootAsJwtConfig(ByteBuffer _bb) {
        return JwtConfig.getRootAsJwtConfig(_bb, new JwtConfig());
    }

    public static JwtConfig getRootAsJwtConfig(ByteBuffer _bb, JwtConfig obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public JwtConfig __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String publicKeyUrl() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer publicKeyUrlAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer publicKeyUrlInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public String publicKey() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer publicKeyAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer publicKeyInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public long publicKeyCacheExpirationSeconds() {
        int o = this.__offset(8);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public String claimAud() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer claimAudAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer claimAudInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public String claimIss() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer claimIssAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer claimIssInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public static int createJwtConfig(FlatBufferBuilder builder, int publicKeyUrlOffset, int publicKeyOffset, long publicKeyCacheExpirationSeconds, int claimAudOffset, int claimIssOffset) {
        builder.startTable(5);
        JwtConfig.addClaimIss(builder, claimIssOffset);
        JwtConfig.addClaimAud(builder, claimAudOffset);
        JwtConfig.addPublicKeyCacheExpirationSeconds(builder, publicKeyCacheExpirationSeconds);
        JwtConfig.addPublicKey(builder, publicKeyOffset);
        JwtConfig.addPublicKeyUrl(builder, publicKeyUrlOffset);
        return JwtConfig.endJwtConfig(builder);
    }

    public static void startJwtConfig(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addPublicKeyUrl(FlatBufferBuilder builder, int publicKeyUrlOffset) {
        builder.addOffset(0, publicKeyUrlOffset, 0);
    }

    public static void addPublicKey(FlatBufferBuilder builder, int publicKeyOffset) {
        builder.addOffset(1, publicKeyOffset, 0);
    }

    public static void addPublicKeyCacheExpirationSeconds(FlatBufferBuilder builder, long publicKeyCacheExpirationSeconds) {
        builder.addInt(2, (int)publicKeyCacheExpirationSeconds, 0);
    }

    public static void addClaimAud(FlatBufferBuilder builder, int claimAudOffset) {
        builder.addOffset(3, claimAudOffset, 0);
    }

    public static void addClaimIss(FlatBufferBuilder builder, int claimIssOffset) {
        builder.addOffset(4, claimIssOffset, 0);
    }

    public static int endJwtConfig(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public JwtConfig get(int j) {
            return this.get(new JwtConfig(), j);
        }

        public JwtConfig get(JwtConfig obj, int j) {
            return obj.__assign(JwtConfig.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

