/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync.server;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.FeatureNotAvailableException;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.sync.Credentials;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.SyncCredentialsToken;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.server.ClusterPeerConfig;
import io.objectbox.sync.server.ClusterPeerInfo;
import io.objectbox.sync.server.JwtConfig;
import io.objectbox.sync.server.SyncServer;
import io.objectbox.sync.server.SyncServerImpl;
import io.objectbox.sync.server.SyncServerOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SyncServerBuilder {
    final BoxStore boxStore;
    final URI url;
    private final List<SyncCredentialsToken> credentials = new ArrayList<SyncCredentialsToken>();
    @Nullable
    private String certificatePath;
    SyncChangeListener changeListener;
    @Nullable
    private String clusterId;
    private final List<ClusterPeerInfo> clusterPeers = new ArrayList<ClusterPeerInfo>();
    private int clusterFlags;
    private long historySizeMaxKb;
    private long historySizeTargetKb;
    private int syncFlags;
    private int syncServerFlags;
    private int workerThreads;
    private String publicKey;
    private String publicKeyUrl;
    private String claimIss;
    private String claimAud;

    private static void checkFeatureSyncServerAvailable() {
        if (!BoxStore.isSyncServerAvailable()) {
            throw new FeatureNotAvailableException("This library does not include ObjectBox Sync Server. Please visit https://objectbox.io/sync/ for options.");
        }
    }

    @Internal
    public SyncServerBuilder(BoxStore boxStore, String url, SyncCredentials authenticatorCredentials) {
        this.checkNotNull(boxStore, "BoxStore is required.");
        this.checkNotNull(url, "Sync server URL is required.");
        this.checkNotNull(authenticatorCredentials, "Authenticator credentials are required.");
        SyncServerBuilder.checkFeatureSyncServerAvailable();
        this.boxStore = boxStore;
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Sync server URL is invalid: " + url, e);
        }
        this.authenticatorCredentials(authenticatorCredentials);
    }

    @Internal
    public SyncServerBuilder(BoxStore boxStore, String url, SyncCredentials[] multipleAuthenticatorCredentials) {
        this.checkNotNull(boxStore, "BoxStore is required.");
        this.checkNotNull(url, "Sync server URL is required.");
        this.checkNotNull(multipleAuthenticatorCredentials, "Authenticator credentials are required.");
        SyncServerBuilder.checkFeatureSyncServerAvailable();
        this.boxStore = boxStore;
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Sync server URL is invalid: " + url, e);
        }
        this.authenticatorCredentials(multipleAuthenticatorCredentials);
    }

    public SyncServerBuilder certificatePath(String certificatePath) {
        this.checkNotNull(certificatePath, "Certificate path must not be null");
        this.certificatePath = certificatePath;
        return this;
    }

    public SyncServerBuilder authenticatorCredentials(SyncCredentials authenticatorCredentials) {
        this.checkNotNull(authenticatorCredentials, "Authenticator credentials must not be null.");
        if (!(authenticatorCredentials instanceof SyncCredentialsToken)) {
            throw new IllegalArgumentException("Sync credentials of type " + (Object)((Object)authenticatorCredentials.getType()) + " are not supported");
        }
        this.credentials.add((SyncCredentialsToken)authenticatorCredentials);
        return this;
    }

    public SyncServerBuilder authenticatorCredentials(SyncCredentials[] multipleAuthenticatorCredentials) {
        this.checkNotNull(multipleAuthenticatorCredentials, "Authenticator credentials must not be null.");
        for (SyncCredentials credentials : multipleAuthenticatorCredentials) {
            this.authenticatorCredentials(credentials);
        }
        return this;
    }

    public SyncServerBuilder changeListener(SyncChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SyncServerBuilder clusterId(String id) {
        this.checkNotNull(id, "Cluster ID must not be null");
        this.clusterId = id;
        return this;
    }

    @Deprecated
    public SyncServerBuilder peer(String url) {
        return this.clusterPeer(url, SyncCredentials.none());
    }

    @Deprecated
    public SyncServerBuilder peer(String url, SyncCredentials credentials) {
        return this.clusterPeer(url, credentials);
    }

    public SyncServerBuilder clusterPeer(String url, SyncCredentials credentials) {
        if (!(credentials instanceof SyncCredentialsToken)) {
            throw new IllegalArgumentException("Sync credentials of type " + (Object)((Object)credentials.getType()) + " are not supported");
        }
        this.clusterPeers.add(new ClusterPeerInfo(url, (SyncCredentialsToken)credentials));
        return this;
    }

    public SyncServerBuilder clusterFlags(int flags) {
        this.clusterFlags = flags;
        return this;
    }

    public SyncServerBuilder historySizeMaxKb(long historySizeMaxKb) {
        this.historySizeMaxKb = historySizeMaxKb;
        return this;
    }

    public SyncServerBuilder historySizeTargetKb(long historySizeTargetKb) {
        this.historySizeTargetKb = historySizeTargetKb;
        return this;
    }

    public SyncServerBuilder syncFlags(int syncFlags) {
        this.syncFlags = syncFlags;
        return this;
    }

    public SyncServerBuilder syncServerFlags(int syncServerFlags) {
        this.syncServerFlags = syncServerFlags;
        return this;
    }

    public SyncServerBuilder workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    public SyncServerBuilder jwtConfigPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public SyncServerBuilder jwtConfigPublicKeyUrl(String publicKeyUrl) {
        this.publicKeyUrl = publicKeyUrl;
        return this;
    }

    public SyncServerBuilder jwtConfigClaimIss(String claimIss) {
        this.claimIss = claimIss;
        return this;
    }

    public SyncServerBuilder jwtConfigClaimAud(String claimAud) {
        this.claimAud = claimAud;
        return this;
    }

    public SyncServer build() {
        if (this.credentials.isEmpty()) {
            throw new IllegalStateException("At least one authenticator is required.");
        }
        if (!this.clusterPeers.isEmpty() || this.clusterFlags != 0) {
            this.checkNotNull(this.clusterId, "Cluster ID must be set to use cluster features.");
        }
        return new SyncServerImpl(this);
    }

    public SyncServer buildAndStart() {
        SyncServer syncServer = this.build();
        syncServer.start();
        return syncServer;
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    byte[] buildSyncServerOptions() {
        FlatBufferBuilder fbb = new FlatBufferBuilder();
        fbb.forceDefaults(true);
        int urlOffset = fbb.createString(this.url.toString());
        int certificatePathOffset = 0;
        if (this.certificatePath != null) {
            certificatePathOffset = fbb.createString(this.certificatePath);
        }
        int clusterIdOffset = 0;
        if (this.clusterId != null) {
            clusterIdOffset = fbb.createString(this.clusterId);
        }
        int authenticationMethodsOffset = this.buildAuthenticationMethods(fbb);
        int clusterPeersVectorOffset = this.buildClusterPeers(fbb);
        int jwtConfigOffset = 0;
        if (this.publicKey != null || this.publicKeyUrl != null) {
            if (this.claimAud == null) {
                throw new IllegalArgumentException("claimAud must be set");
            }
            if (this.claimIss == null) {
                throw new IllegalArgumentException("claimIss must be set");
            }
            jwtConfigOffset = this.buildJwtConfig(fbb, this.publicKey, this.publicKeyUrl, this.claimIss, this.claimAud);
        }
        for (SyncCredentialsToken credential : this.credentials) {
            credential.clear();
        }
        for (ClusterPeerInfo peer : this.clusterPeers) {
            peer.credentials.clear();
        }
        SyncServerOptions.startSyncServerOptions(fbb);
        SyncServerOptions.addUrl(fbb, urlOffset);
        SyncServerOptions.addAuthenticationMethods(fbb, authenticationMethodsOffset);
        if (this.syncFlags != 0) {
            SyncServerOptions.addSyncFlags(fbb, this.syncFlags);
        }
        if (this.syncServerFlags != 0) {
            SyncServerOptions.addSyncFlags(fbb, this.syncServerFlags);
        }
        if (certificatePathOffset != 0) {
            SyncServerOptions.addCertificatePath(fbb, certificatePathOffset);
        }
        if (this.workerThreads != 0) {
            SyncServerOptions.addWorkerThreads(fbb, this.workerThreads);
        }
        if (this.historySizeMaxKb != 0L) {
            SyncServerOptions.addHistorySizeMaxKb(fbb, this.historySizeMaxKb);
        }
        if (this.historySizeTargetKb != 0L) {
            SyncServerOptions.addHistorySizeTargetKb(fbb, this.historySizeTargetKb);
        }
        if (clusterIdOffset != 0) {
            SyncServerOptions.addClusterId(fbb, clusterIdOffset);
        }
        if (clusterPeersVectorOffset != 0) {
            SyncServerOptions.addClusterPeers(fbb, clusterPeersVectorOffset);
        }
        if (this.clusterFlags != 0) {
            SyncServerOptions.addClusterFlags(fbb, this.clusterFlags);
        }
        if (jwtConfigOffset != 0) {
            SyncServerOptions.addJwtConfig(fbb, jwtConfigOffset);
        }
        int offset = SyncServerOptions.endSyncServerOptions(fbb);
        fbb.finish(offset);
        return fbb.sizedByteArray();
    }

    private int buildAuthenticationMethods(FlatBufferBuilder fbb) {
        int[] credentialsOffsets = new int[this.credentials.size()];
        for (int i = 0; i < this.credentials.size(); ++i) {
            credentialsOffsets[i] = this.buildCredentials(fbb, this.credentials.get(i));
        }
        return SyncServerOptions.createAuthenticationMethodsVector(fbb, credentialsOffsets);
    }

    private int buildCredentials(FlatBufferBuilder fbb, SyncCredentialsToken tokenCredentials) {
        int tokenBytesOffset = 0;
        byte[] tokenBytes = tokenCredentials.getTokenBytes();
        if (tokenBytes != null) {
            tokenBytesOffset = Credentials.createBytesVector(fbb, tokenBytes);
        }
        Credentials.startCredentials(fbb);
        Credentials.addType(fbb, tokenCredentials.getTypeId());
        if (tokenBytesOffset != 0) {
            Credentials.addBytes(fbb, tokenBytesOffset);
        }
        return Credentials.endCredentials(fbb);
    }

    private int buildJwtConfig(FlatBufferBuilder fbb, @Nullable String publicKey, @Nullable String publicKeyUrl, String claimIss, String claimAud) {
        if (publicKey == null && publicKeyUrl == null) {
            throw new IllegalArgumentException("Either publicKey or publicKeyUrl must be set");
        }
        int publicKeyOffset = 0;
        int publicKeyUrlOffset = 0;
        if (publicKey != null) {
            publicKeyOffset = fbb.createString(publicKey);
        } else {
            publicKeyUrlOffset = fbb.createString(publicKeyUrl);
        }
        int claimIssOffset = fbb.createString(claimIss);
        int claimAudOffset = fbb.createString(claimAud);
        JwtConfig.startJwtConfig(fbb);
        if (publicKeyOffset != 0) {
            JwtConfig.addPublicKey(fbb, publicKeyOffset);
        } else {
            JwtConfig.addPublicKeyUrl(fbb, publicKeyUrlOffset);
        }
        JwtConfig.addClaimIss(fbb, claimIssOffset);
        JwtConfig.addClaimAud(fbb, claimAudOffset);
        return JwtConfig.endJwtConfig(fbb);
    }

    private int buildClusterPeers(FlatBufferBuilder fbb) {
        if (this.clusterPeers.isEmpty()) {
            return 0;
        }
        int[] peersOffsets = new int[this.clusterPeers.size()];
        for (int i = 0; i < this.clusterPeers.size(); ++i) {
            ClusterPeerInfo peer = this.clusterPeers.get(i);
            int urlOffset = fbb.createString(peer.url);
            int credentialsOffset = this.buildCredentials(fbb, peer.credentials);
            peersOffsets[i] = ClusterPeerConfig.createClusterPeerConfig(fbb, urlOffset, credentialsOffset);
        }
        return SyncServerOptions.createClusterPeersVector(fbb, peersOffsets);
    }
}

