/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.internal;

import io.objectbox.annotation.apihint.Internal;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@Internal
public class ReflectionCache {
    private static final ReflectionCache instance = new ReflectionCache();
    private final Map<Class<?>, Map<String, Field>> fields = new HashMap();

    public static ReflectionCache getInstance() {
        return instance;
    }

    @Nonnull
    public synchronized Field getField(Class<?> clazz, String name) {
        Field field;
        Map<String, Field> fieldsForClass = this.fields.get(clazz);
        if (fieldsForClass == null) {
            fieldsForClass = new HashMap<String, Field>();
            this.fields.put(clazz, fieldsForClass);
        }
        if ((field = fieldsForClass.get(name)) == null) {
            try {
                field = clazz.getDeclaredField(name);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
            fieldsForClass.put(name, field);
        }
        return field;
    }
}

