/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.Cursor;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncClient;
import javax.annotation.Nullable;

@Internal
public class InternalAccess {
    @Internal
    public static Transaction getActiveTx(BoxStore boxStore) {
        Transaction tx = boxStore.activeTx.get();
        if (tx == null) {
            throw new IllegalStateException("No active transaction");
        }
        tx.checkOpen();
        return tx;
    }

    @Internal
    public static long getHandle(Transaction tx) {
        return tx.internalHandle();
    }

    @Internal
    public static void setSyncClient(BoxStore boxStore, @Nullable SyncClient syncClient) {
        boxStore.setSyncClient(syncClient);
    }

    @Internal
    public static <T> Cursor<T> getWriter(Box<T> box) {
        return box.getWriter();
    }

    @Internal
    public static <T> Cursor<T> getActiveTxCursor(Box<T> box) {
        return box.getActiveTxCursor();
    }

    @Internal
    public static <T> long getActiveTxCursorHandle(Box<T> box) {
        return box.getActiveTxCursor().internalHandle();
    }

    @Internal
    public static <T> void commitWriter(Box<T> box, Cursor<T> writer) {
        box.commitWriter(writer);
    }

    @Internal
    public static void enableCreationStackTracking() {
        Transaction.TRACK_CREATION_STACK = true;
        Cursor.TRACK_CREATION_STACK = true;
    }

    @Internal
    public static BoxStoreBuilder clone(BoxStoreBuilder original, String namePostfix) {
        return original.createClone(namePostfix);
    }
}

