/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Document;
import io.prismic.DocumentLinkResolver;
import io.prismic.GroupDoc;
import io.prismic.HtmlSerializer;
import io.prismic.WithFragments;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public interface Fragment {

    public static class Group
    implements Fragment {
        private final List<GroupDoc> groupDocs;

        public Group(List<GroupDoc> groupDocs) {
            this.groupDocs = Collections.unmodifiableList(groupDocs);
        }

        public List<GroupDoc> getDocs() {
            return this.groupDocs;
        }

        @Deprecated
        public List<Map<String, Fragment>> toMapList() {
            ArrayList<Map<String, Fragment>> result = new ArrayList<Map<String, Fragment>>();
            for (GroupDoc groupDoc : this.groupDocs) {
                result.add(groupDoc.getFragments());
            }
            return result;
        }

        public String asHtml(DocumentLinkResolver linkResolver) {
            StringBuilder sb = new StringBuilder();
            for (GroupDoc groupDoc : this.groupDocs) {
                sb.append(groupDoc.asHtml(linkResolver));
            }
            return sb.toString();
        }

        static Group parse(JsonNode json) {
            ArrayList<GroupDoc> groupDocs = new ArrayList<GroupDoc>();
            for (JsonNode groupJson : json) {
                Iterator dataJson = groupJson.fieldNames();
                HashMap<String, Fragment> fragmentMap = new HashMap<String, Fragment>();
                while (dataJson.hasNext()) {
                    JsonNode fragmentValue;
                    String field = (String)dataJson.next();
                    JsonNode fieldJson = groupJson.path(field);
                    String fragmentType = fieldJson.path("type").asText();
                    Fragment fragment = Document.parseFragment(fragmentType, fragmentValue = fieldJson.path("value"));
                    if (fragment == null) continue;
                    fragmentMap.put(field, fragment);
                }
                groupDocs.add(new GroupDoc(fragmentMap));
            }
            return new Group(groupDocs);
        }
    }

    public static class StructuredText
    implements Fragment {
        final List<Block> blocks;

        public StructuredText(List<Block> blocks) {
            this.blocks = blocks;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public Block.Heading getTitle() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Heading)) continue;
                return (Block.Heading)block;
            }
            return null;
        }

        public Block.Paragraph getFirstParagraph() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Paragraph)) continue;
                return (Block.Paragraph)block;
            }
            return null;
        }

        public Block.Preformatted getFirstPreformatted() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Preformatted)) continue;
                return (Block.Preformatted)block;
            }
            return null;
        }

        public Block.Image getFirstImage() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Image)) continue;
                return (Block.Image)block;
            }
            return null;
        }

        public String asHtml(List<Block> blocks, DocumentLinkResolver linkResolver, HtmlSerializer htmlSerializer) {
            ArrayList<BlockGroup> blockGroups = new ArrayList<BlockGroup>();
            for (Block block : blocks) {
                BlockGroup newBlockGroup;
                BlockGroup lastOne;
                BlockGroup blockGroup = lastOne = blockGroups.isEmpty() ? null : (BlockGroup)blockGroups.get(blockGroups.size() - 1);
                if (lastOne != null && "ul".equals(lastOne.tag) && block instanceof Block.ListItem && !((Block.ListItem)block).isOrdered()) {
                    lastOne.blocks.add(block);
                    continue;
                }
                if (lastOne != null && "ol".equals(lastOne.tag) && block instanceof Block.ListItem && ((Block.ListItem)block).isOrdered()) {
                    lastOne.blocks.add(block);
                    continue;
                }
                if (block instanceof Block.ListItem && !((Block.ListItem)block).isOrdered()) {
                    newBlockGroup = new BlockGroup("ul", new ArrayList<Block>());
                    newBlockGroup.blocks.add(block);
                    blockGroups.add(newBlockGroup);
                    continue;
                }
                if (block instanceof Block.ListItem && ((Block.ListItem)block).isOrdered()) {
                    newBlockGroup = new BlockGroup("ol", new ArrayList<Block>());
                    newBlockGroup.blocks.add(block);
                    blockGroups.add(newBlockGroup);
                    continue;
                }
                newBlockGroup = new BlockGroup(null, new ArrayList<Block>());
                newBlockGroup.blocks.add(block);
                blockGroups.add(newBlockGroup);
            }
            StringBuilder html = new StringBuilder();
            for (BlockGroup blockGroup : blockGroups) {
                if (blockGroup.tag != null) {
                    html.append("<" + blockGroup.tag + ">");
                    for (Block block : blockGroup.blocks) {
                        html.append(this.asHtml(block, linkResolver, htmlSerializer));
                    }
                    html.append("</" + blockGroup.tag + ">");
                    continue;
                }
                for (Block block : blockGroup.blocks) {
                    html.append(this.asHtml(block, linkResolver, htmlSerializer));
                }
            }
            return html.toString();
        }

        public String asHtml(Block block, DocumentLinkResolver linkResolver, HtmlSerializer htmlSerializer) {
            String classCode;
            String customHtml;
            Block.Text paragraph;
            String content = "";
            if (block instanceof Block.Heading) {
                Block.Heading heading = (Block.Heading)block;
                content = this.insertSpans(heading.getText(), heading.getSpans(), linkResolver, htmlSerializer);
            } else if (block instanceof Block.Paragraph) {
                paragraph = (Block.Paragraph)block;
                content = this.insertSpans(((Block.Paragraph)paragraph).getText(), ((Block.Paragraph)paragraph).getSpans(), linkResolver, htmlSerializer);
            } else if (block instanceof Block.Preformatted) {
                paragraph = (Block.Preformatted)block;
                content = this.insertSpans(((Block.Preformatted)paragraph).getText(), ((Block.Preformatted)paragraph).getSpans(), linkResolver, htmlSerializer);
            } else if (block instanceof Block.ListItem) {
                Block.ListItem listItem = (Block.ListItem)block;
                content = this.insertSpans(listItem.getText(), listItem.getSpans(), linkResolver, htmlSerializer);
            }
            if (htmlSerializer != null && (customHtml = htmlSerializer.serialize(block, content)) != null) {
                return customHtml;
            }
            String string = classCode = block.getLabel() == null ? "" : " class=\"" + block.getLabel() + "\"";
            if (block instanceof Block.Heading) {
                Block.Heading heading = (Block.Heading)block;
                return "<h" + heading.getLevel() + classCode + ">" + content + "</h" + heading.getLevel() + ">";
            }
            if (block instanceof Block.Paragraph) {
                return "<p" + classCode + ">" + content + "</p>";
            }
            if (block instanceof Block.Preformatted) {
                return "<pre" + classCode + ">" + content + "</pre>";
            }
            if (block instanceof Block.ListItem) {
                return "<li" + classCode + ">" + content + "</li>";
            }
            if (block instanceof Block.Image) {
                Block.Image image = (Block.Image)block;
                String labelCode = block.getLabel() == null ? "" : " " + block.getLabel();
                return "<p class=\"block-img" + labelCode + "\">" + image.getView().asHtml(linkResolver) + "</p>";
            }
            if (block instanceof Block.Embed) {
                Block.Embed embed = (Block.Embed)block;
                return embed.getObj().asHtml();
            }
            return "";
        }

        private static String serialize(Span span, String content, DocumentLinkResolver linkResolver, HtmlSerializer htmlSerializer) {
            String customHtml;
            if (htmlSerializer != null && (customHtml = htmlSerializer.serialize(span, content)) != null) {
                return customHtml;
            }
            if (span instanceof Span.Strong) {
                return "<strong>" + content + "</strong>";
            }
            if (span instanceof Span.Em) {
                return "<em>" + content + "</em>";
            }
            if (span instanceof Span.Label) {
                return "<span class=\"" + ((Span.Label)span).getLabel() + "\">" + content + "</span>";
            }
            if (span instanceof Span.Hyperlink) {
                Span.Hyperlink hyperlink = (Span.Hyperlink)span;
                if (hyperlink.link instanceof WebLink) {
                    WebLink webLink = (WebLink)hyperlink.getLink();
                    return "<a href=\"" + webLink.getUrl() + "\">" + content + "</a>";
                }
                if (hyperlink.link instanceof FileLink) {
                    FileLink fileLink = (FileLink)hyperlink.getLink();
                    return "<a href=\"" + fileLink.getUrl() + "\">" + content + "</a>";
                }
                if (hyperlink.link instanceof ImageLink) {
                    ImageLink imageLink = (ImageLink)hyperlink.getLink();
                    return "<a href=\"" + imageLink.getUrl() + "\">" + content + "</a>";
                }
                if (hyperlink.link instanceof DocumentLink) {
                    DocumentLink documentLink = (DocumentLink)hyperlink.getLink();
                    String url = linkResolver.resolveLink(documentLink);
                    return "<a " + (linkResolver.getTitle(documentLink) == null ? "" : "title=\"" + linkResolver.getTitle(documentLink) + "\" ") + "href=\"" + url + "\">" + content + "</a>";
                }
            }
            return "<span>" + content + "</span>";
        }

        private String insertSpans(String text, List<Span> spans, DocumentLinkResolver linkResolver, HtmlSerializer htmlSerializer) {
            if (spans.isEmpty()) {
                return StructuredText.escape(text);
            }
            HashMap tagsStart = new HashMap();
            HashMap tagsEnd = new HashMap();
            for (Span span : spans) {
                if (!tagsStart.containsKey(span.getStart())) {
                    tagsStart.put(span.getStart(), new ArrayList());
                }
                if (!tagsEnd.containsKey(span.getEnd())) {
                    tagsEnd.put(span.getEnd(), new ArrayList());
                }
                ((List)tagsStart.get(span.getStart())).add(span);
                ((List)tagsEnd.get(span.getEnd())).add(span);
            }
            String html = "";
            Stack<Tuple<Object, String>> stack = new Stack<Tuple<Object, String>>();
            int len = text.length();
            for (int pos = 0; pos < len; ++pos) {
                if (tagsEnd.containsKey(pos)) {
                    for (Span span : (List)tagsEnd.get(pos)) {
                        Tuple tag = (Tuple)stack.pop();
                        String innerHtml = StructuredText.serialize((Span)tag.x, (String)tag.y, linkResolver, htmlSerializer);
                        if (stack.isEmpty()) {
                            html = html + innerHtml;
                            continue;
                        }
                        Tuple head = (Tuple)stack.pop();
                        stack.push(new Tuple(head.x, (String)head.y + innerHtml));
                    }
                }
                if (tagsStart.containsKey(pos)) {
                    for (Span span : (List)tagsStart.get(pos)) {
                        stack.push(new Tuple<Span, String>(span, ""));
                    }
                }
                char c = text.charAt(pos);
                String escaped = StructuredText.escape(Character.toString(c));
                if (stack.isEmpty()) {
                    html = html + escaped;
                    continue;
                }
                Tuple head = (Tuple)stack.pop();
                stack.push(new Tuple(head.x, (String)head.y + escaped));
            }
            while (!stack.empty()) {
                Tuple tag = (Tuple)stack.pop();
                String innerHtml = StructuredText.serialize((Span)tag.x, (String)tag.y, linkResolver, htmlSerializer);
                if (stack.isEmpty()) {
                    html = html + innerHtml;
                    continue;
                }
                Tuple head = (Tuple)stack.pop();
                stack.push(new Tuple(head.x, (String)head.y + innerHtml));
            }
            return html;
        }

        public String asHtml(DocumentLinkResolver linkResolver) {
            return this.asHtml(linkResolver, null);
        }

        public String asHtml(DocumentLinkResolver linkResolver, HtmlSerializer htmlSerializer) {
            return this.asHtml(this.getBlocks(), linkResolver, htmlSerializer);
        }

        private static String escape(String input) {
            return input.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }

        static Link parseLink(JsonNode json) {
            if (json.isMissingNode()) {
                return null;
            }
            String linkType = json.path("type").asText();
            JsonNode value = json.with("value");
            if ("Link.web".equals(linkType)) {
                return WebLink.parse(value);
            }
            if ("Link.document".equals(linkType)) {
                return DocumentLink.parse(value);
            }
            if ("Link.file".equals(linkType)) {
                return FileLink.parse(value);
            }
            if ("Link.image".equals(linkType)) {
                return ImageLink.parse(value);
            }
            return null;
        }

        static Span parseSpan(JsonNode json) {
            String type = json.path("type").asText();
            int start = json.path("start").intValue();
            int end = json.path("end").intValue();
            JsonNode data = json.with("data");
            if (end > start) {
                Link link;
                if ("strong".equals(type)) {
                    return new Span.Strong(start, end);
                }
                if ("em".equals(type)) {
                    return new Span.Em(start, end);
                }
                if ("hyperlink".equals(type) && (link = StructuredText.parseLink(data)) != null) {
                    return new Span.Hyperlink(start, end, link);
                }
                if ("label".equals(type)) {
                    String label = data.path("label").asText();
                    return new Span.Label(start, end, label);
                }
            }
            return null;
        }

        static ParsedText parseText(JsonNode json) {
            String text = json.path("text").asText();
            ArrayList<Span> spans = new ArrayList<Span>();
            for (JsonNode spanJson : json.withArray("spans")) {
                Span span = StructuredText.parseSpan(spanJson);
                if (span == null) continue;
                spans.add(span);
            }
            return new ParsedText(text, spans);
        }

        static Block parseBlock(JsonNode json) {
            String type = json.path("type").asText();
            String label = json.path("label").textValue();
            if ("heading1".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 1, label);
            }
            if ("heading2".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 2, label);
            }
            if ("heading3".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 3, label);
            }
            if ("heading4".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 4, label);
            }
            if ("paragraph".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Paragraph(p.text, p.spans, label);
            }
            if ("preformatted".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Preformatted(p.text, p.spans, label);
            }
            if ("list-item".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.ListItem(p.text, p.spans, false, label);
            }
            if ("o-list-item".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.ListItem(p.text, p.spans, true, label);
            }
            if ("image".equals(type)) {
                Image.View view = Image.View.parse(json);
                return new Block.Image(view, label);
            }
            if ("embed".equals(type)) {
                Embed obj = Embed.parse(json);
                return new Block.Embed(obj, label);
            }
            return null;
        }

        static StructuredText parse(JsonNode json) {
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (JsonNode blockJson : json) {
                Block block = StructuredText.parseBlock(blockJson);
                if (block == null) continue;
                blocks.add(block);
            }
            return new StructuredText(blocks);
        }

        private static class ParsedText {
            final String text;
            final List<Span> spans;

            public ParsedText(String text, List<Span> spans) {
                this.text = text;
                this.spans = spans;
            }
        }

        static class Tuple<X, Y> {
            public final X x;
            public final Y y;

            public Tuple(X x, Y y) {
                this.x = x;
                this.y = y;
            }
        }

        private static class BlockGroup {
            final String tag;
            final List<Block> blocks;

            public BlockGroup(String tag, List<Block> blocks) {
                this.tag = tag;
                this.blocks = blocks;
            }
        }

        public static interface Span
        extends Element {
            public int getStart();

            public int getEnd();

            public static class Label
            implements Span {
                private final int start;
                private final int end;
                private final String label;

                public Label(int start, int end, String label) {
                    this.start = start;
                    this.end = end;
                    this.label = label;
                }

                @Override
                public int getStart() {
                    return this.start;
                }

                @Override
                public int getEnd() {
                    return this.end;
                }

                public String getLabel() {
                    return this.label;
                }
            }

            public static class Hyperlink
            implements Span {
                private final int start;
                private final int end;
                private final Link link;

                public Hyperlink(int start, int end, Link link) {
                    this.start = start;
                    this.end = end;
                    this.link = link;
                }

                @Override
                public int getStart() {
                    return this.start;
                }

                @Override
                public int getEnd() {
                    return this.end;
                }

                public Link getLink() {
                    return this.link;
                }
            }

            public static class Strong
            implements Span {
                private final int start;
                private final int end;

                public Strong(int start, int end) {
                    this.start = start;
                    this.end = end;
                }

                @Override
                public int getStart() {
                    return this.start;
                }

                @Override
                public int getEnd() {
                    return this.end;
                }
            }

            public static class Em
            implements Span {
                private final int start;
                private final int end;

                public Em(int start, int end) {
                    this.start = start;
                    this.end = end;
                }

                @Override
                public int getStart() {
                    return this.start;
                }

                @Override
                public int getEnd() {
                    return this.end;
                }
            }
        }

        public static interface Block
        extends Element {
            public String getLabel();

            public static class Embed
            implements Block {
                private final io.prismic.Fragment$Embed obj;
                private final String label;

                public Embed(io.prismic.Fragment$Embed obj, String label) {
                    this.obj = obj;
                    this.label = label;
                }

                public io.prismic.Fragment$Embed getObj() {
                    return this.obj;
                }

                @Override
                public String getLabel() {
                    return this.label;
                }
            }

            public static class Image
            implements Block {
                private final Image.View view;
                private final String label;

                public Image(Image.View view, String label) {
                    this.view = view;
                    this.label = label;
                }

                public Image.View getView() {
                    return this.view;
                }

                public String getUrl() {
                    return this.view.getUrl();
                }

                public int getWidth() {
                    return this.view.getWidth();
                }

                public int getHeight() {
                    return this.view.getHeight();
                }

                @Override
                public String getLabel() {
                    return this.label;
                }
            }

            public static class ListItem
            implements Text {
                private final String text;
                private final List<Span> spans;
                private final boolean ordered;
                private final String label;

                public ListItem(String text, List<Span> spans, boolean ordered, String label) {
                    this.text = text;
                    this.spans = spans;
                    this.ordered = ordered;
                    this.label = label;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }

                public boolean isOrdered() {
                    return this.ordered;
                }

                @Override
                public String getLabel() {
                    return this.label;
                }
            }

            public static class Preformatted
            implements Text {
                private final String text;
                private final List<Span> spans;
                private final String label;

                public Preformatted(String text, List<Span> spans, String label) {
                    this.text = text;
                    this.spans = spans;
                    this.label = label;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }

                @Override
                public String getLabel() {
                    return this.label;
                }
            }

            public static class Paragraph
            implements Text {
                private final String text;
                private final List<Span> spans;
                private final String label;

                public Paragraph(String text, List<Span> spans, String label) {
                    this.text = text;
                    this.spans = spans;
                    this.label = label;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }

                @Override
                public String getLabel() {
                    return this.label;
                }
            }

            public static class Heading
            implements Text {
                private final String text;
                private final List<Span> spans;
                private final int level;
                private final String label;

                public Heading(String text, List<Span> spans, int level, String label) {
                    this.text = text;
                    this.spans = spans;
                    this.level = level;
                    this.label = label;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }

                public int getLevel() {
                    return this.level;
                }

                @Override
                public String getLabel() {
                    return this.label;
                }
            }

            public static interface Text
            extends Block {
                public String getText();

                public List<Span> getSpans();
            }
        }

        public static interface Element {
        }
    }

    public static class Image
    implements Fragment {
        private final View main;
        private final Map<String, View> views;

        public Image(View main, Map<String, View> views) {
            this.main = main;
            this.views = views;
        }

        public Image(View main) {
            this(main, new HashMap<String, View>());
        }

        public View getView(String view) {
            if ("main".equals(view)) {
                return this.main;
            }
            return this.views.get(view);
        }

        public String asHtml(DocumentLinkResolver linkResolver) {
            return this.getView("main").asHtml(linkResolver);
        }

        static Image parse(JsonNode json) {
            View main = View.parse(json.with("main"));
            HashMap<String, View> views = new HashMap<String, View>();
            Iterator viewsJson = json.with("views").fieldNames();
            while (viewsJson.hasNext()) {
                String view = (String)viewsJson.next();
                views.put(view, View.parse(json.with("views").with(view)));
            }
            return new Image(main, views);
        }

        public static class View {
            private final String url;
            private final int width;
            private final int height;
            private final String alt;
            private final String copyright;
            private final Link linkTo;

            public View(String url, int width, int height, String alt, String copyright, Link linkTo) {
                this.url = url;
                this.width = width;
                this.height = height;
                this.alt = alt;
                this.copyright = copyright;
                this.linkTo = linkTo;
            }

            public String getUrl() {
                return this.url;
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }

            public String getAlt() {
                return this.alt;
            }

            public String getCopyright() {
                return this.copyright;
            }

            public double ratio() {
                return (double)this.width / (double)this.height;
            }

            public String asHtml(DocumentLinkResolver linkResolver) {
                String imgTag = "<img alt=\"" + this.alt + "\" src=\"" + this.url + "\" width=\"" + this.width + "\" height=\"" + this.height + "\" />";
                if (this.linkTo != null) {
                    String url = "about:blank";
                    if (this.linkTo instanceof WebLink) {
                        url = ((WebLink)this.linkTo).getUrl();
                    } else if (this.linkTo instanceof ImageLink) {
                        url = ((ImageLink)this.linkTo).getUrl();
                    } else if (this.linkTo instanceof DocumentLink) {
                        url = ((DocumentLink)this.linkTo).isBroken() ? "#broken" : linkResolver.resolve((DocumentLink)this.linkTo);
                    }
                    return "<a href=\"" + url + "\">" + imgTag + "</a>";
                }
                return imgTag;
            }

            static View parse(JsonNode json) {
                String url = json.path("url").asText();
                int width = json.with("dimensions").path("width").intValue();
                int height = json.with("dimensions").path("height").intValue();
                String alt = json.path("alt").asText();
                String copyright = json.path("copyright").asText();
                Link linkTo = StructuredText.parseLink(json.path("linkTo"));
                return new View(url, width, height, alt, copyright, linkTo);
            }
        }
    }

    public static class DocumentLink
    extends WithFragments
    implements Link {
        private final String id;
        private final String uid;
        private final String type;
        private final Set<String> tags;
        private final String slug;
        private final boolean broken;
        private final Map<String, Fragment> fragments;

        public DocumentLink(String id, String uid, String type, Set<String> tags, String slug, Map<String, Fragment> fragments, boolean broken) {
            this.id = id;
            this.uid = uid;
            this.type = type;
            this.tags = tags;
            this.slug = slug;
            this.fragments = fragments;
            this.broken = broken;
        }

        @Override
        public String getUrl(DocumentLinkResolver resolver) {
            return resolver.resolve(this);
        }

        public String getId() {
            return this.id;
        }

        public String getUid() {
            return this.uid;
        }

        public String getType() {
            return this.type;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public String getSlug() {
            return this.slug;
        }

        public boolean isBroken() {
            return this.broken;
        }

        @Override
        public Map<String, Fragment> getFragments() {
            return this.fragments;
        }

        @Override
        public String asHtml(DocumentLinkResolver linkResolver) {
            return "<a " + (linkResolver.getTitle(this) == null ? "" : "title=\"" + linkResolver.getTitle(this) + "\" ") + "href=\"" + linkResolver.resolve(this) + "\">" + this.slug + "</a>";
        }

        static DocumentLink parse(JsonNode json) {
            JsonNode document = json.with("document");
            boolean broken = json.path("isBroken").booleanValue();
            String id = document.path("id").asText();
            String uid = document.path("uid").asText();
            String type = document.path("type").asText();
            String slug = document.path("slug").asText();
            HashSet<String> tags = new HashSet<String>();
            for (JsonNode tagJson : document.withArray("tags")) {
                tags.add(tagJson.asText());
            }
            Map<String, Fragment> fragments = Document.parseFragments(document.with("data").with(type), type);
            return new DocumentLink(id, uid, type, tags, slug, fragments, broken);
        }
    }

    public static class ImageLink
    implements Link {
        private final String url;

        public ImageLink(String url) {
            this.url = url;
        }

        @Override
        public String getUrl(DocumentLinkResolver resolver) {
            return this.url;
        }

        public String getUrl() {
            return this.url;
        }

        public String asHtml() {
            return "<a href=\"" + this.url + "\">" + this.url + "</a>";
        }

        static ImageLink parse(JsonNode json) {
            String url = json.path("image").path("url").asText();
            return new ImageLink(url);
        }
    }

    public static class FileLink
    implements Link {
        private final String url;
        private final String kind;
        private final Long size;
        private final String filename;

        public FileLink(String url, String kind, Long size, String filename) {
            this.url = url;
            this.kind = kind;
            this.size = size;
            this.filename = filename;
        }

        @Override
        public String getUrl(DocumentLinkResolver resolver) {
            return this.url;
        }

        public String getUrl() {
            return this.url;
        }

        public String getKind() {
            return this.kind;
        }

        public Long getSize() {
            return this.size;
        }

        public String getFilename() {
            return this.filename;
        }

        public String asHtml() {
            return "<a href=\"" + this.url + "\">" + this.filename + "</a>";
        }

        static FileLink parse(JsonNode json) {
            String url = json.path("file").path("url").asText();
            String kind = json.path("file").path("kind").asText();
            String size = json.path("file").path("size").asText();
            String name = json.path("file").path("name").asText();
            return new FileLink(url, kind, Long.parseLong(size), name);
        }
    }

    public static class WebLink
    implements Link {
        private final String url;
        private final String contentType;

        public WebLink(String url, String contentType) {
            this.url = url;
            this.contentType = contentType;
        }

        @Override
        public String getUrl(DocumentLinkResolver resolver) {
            return this.url;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String asHtml() {
            return "<a href=\"" + this.url + "\">" + this.url + "</a>";
        }

        static WebLink parse(JsonNode json) {
            String url = json.path("url").asText();
            return new WebLink(url, null);
        }
    }

    public static interface Link
    extends Fragment {
        public String getUrl(DocumentLinkResolver var1);
    }

    public static class Embed
    implements Fragment {
        private final String type;
        private final String provider;
        private final String url;
        private final Integer width;
        private final Integer height;
        private final String html;
        private final JsonNode oembedJson;

        public Embed(String type, String provider, String url, Integer width, Integer height, String html, JsonNode oembedJson) {
            this.type = type;
            this.provider = provider;
            this.url = url;
            this.width = width;
            this.height = height;
            this.html = html;
            this.oembedJson = oembedJson;
        }

        public String getType() {
            return this.type;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getUrl() {
            return this.url;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public String getHtml() {
            return this.html;
        }

        public JsonNode getOEmbedJson() {
            return this.oembedJson;
        }

        public String asHtml() {
            String providerTag = "";
            if (this.provider != null) {
                providerTag = " data-oembed-provider=\"" + this.provider.toLowerCase() + "\"";
            }
            return "<div data-oembed=\"" + this.url + "\" data-oembed-type=\"" + this.type.toLowerCase() + "\"" + providerTag + ">" + this.html + "</div>";
        }

        static Embed parse(JsonNode json) {
            JsonNode oembedJson = json.with("oembed");
            String type = oembedJson.path("type").asText();
            String provider = oembedJson.has("provider_name") ? oembedJson.path("provider_name").asText() : null;
            String url = oembedJson.path("embed_url").asText();
            Integer width = oembedJson.has("width") && oembedJson.path("width").isNumber() ? Integer.valueOf(oembedJson.path("width").intValue()) : null;
            Integer height = oembedJson.has("height") && oembedJson.path("height").isNumber() ? Integer.valueOf(oembedJson.path("height").intValue()) : null;
            String html = oembedJson.path("html").asText();
            return new Embed(type, provider, url, width, height, html, oembedJson);
        }
    }

    public static class GeoPoint
    implements Fragment {
        private final Double latitude;
        private final Double longitude;

        public GeoPoint(Double latitude, Double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        static GeoPoint parse(JsonNode json) {
            try {
                Double latitude = json.has("latitude") && json.path("latitude").isNumber() ? Double.valueOf(json.path("latitude").doubleValue()) : null;
                Double longitude = json.has("longitude") && json.path("longitude").isNumber() ? Double.valueOf(json.path("longitude").doubleValue()) : null;
                return new GeoPoint(latitude, longitude);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Color
    implements Fragment {
        private final String hex;

        public Color(String hex) {
            this.hex = hex;
        }

        public String getHexValue() {
            return this.hex;
        }

        public String asHtml() {
            return "<span class=\"color\">" + this.hex + "</span>";
        }

        static Color parse(JsonNode json) {
            String hex = json.asText();
            if (hex.matches("#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})")) {
                return new Color(hex);
            }
            return null;
        }
    }

    public static class Number
    implements Fragment {
        private final Double value;

        public Number(Double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }

        public String asText(String pattern) {
            return new DecimalFormat(pattern).format(this.value);
        }

        public String asHtml() {
            return "<span class=\"number\">" + this.value + "</span>";
        }

        static Number parse(JsonNode json) {
            try {
                return new Number(Double.parseDouble(json.asText()));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Timestamp
    implements Fragment {
        private final DateTime value;
        private static DateTimeFormatter isoFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");

        public Timestamp(DateTime value) {
            this.value = value;
        }

        public DateTime getValue() {
            return this.value;
        }

        public String asText(String pattern) {
            return this.value.toString(pattern);
        }

        public String asHtml() {
            return "<time>" + this.value + "</time>";
        }

        static Timestamp parse(JsonNode json) {
            try {
                return new Timestamp(DateTime.parse((String)json.asText(), (DateTimeFormatter)isoFormat));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Date
    implements Fragment {
        private final LocalDate value;

        public Date(LocalDate value) {
            this.value = value;
        }

        public LocalDate getValue() {
            return this.value;
        }

        public String asText(String pattern) {
            return this.value.toString(pattern);
        }

        public String asHtml() {
            return "<time>" + this.value + "</time>";
        }

        static Date parse(JsonNode json) {
            try {
                return new Date(LocalDate.parse((String)json.asText(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd")));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Text
    implements Fragment {
        private final String value;

        public Text(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String asHtml() {
            return "<span class=\"text\">" + this.value + "</span>";
        }

        static Text parse(JsonNode json) {
            return new Text(json.asText());
        }
    }
}

