/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;

public interface Cache {
    public void set(String var1, Long var2, JsonNode var3);

    public JsonNode get(String var1);

    public JsonNode getOrSet(String var1, Long var2, Callback var3);

    public static class BuiltInCache
    implements Cache {
        private final Map<String, Entry> cache;

        public BuiltInCache(int maxDocuments) {
            this.cache = Collections.synchronizedMap(new LRUMap(maxDocuments));
        }

        @Override
        public JsonNode get(String key) {
            Entry entry = this.cache.get(key);
            Boolean isExpired = this.isExpired(key);
            if (entry != null && !isExpired.booleanValue()) {
                return entry.value;
            }
            return null;
        }

        @Override
        public void set(String key, Long ttl, JsonNode response) {
            Long expiration = ttl + System.currentTimeMillis();
            this.cache.put(key, new Entry(expiration, response));
        }

        @Override
        public JsonNode getOrSet(String key, Long ttl, Callback f) {
            JsonNode found = this.get(key);
            if (found == null) {
                JsonNode json = f.execute();
                this.set(key, ttl, json);
                return json;
            }
            return found;
        }

        private Boolean isExpired(String key) {
            Entry entry = this.cache.get(key);
            return entry != null && entry.expiration != 0L && entry.expiration < System.currentTimeMillis();
        }

        static class Entry {
            public final Long expiration;
            public final JsonNode value;

            public Entry(Long expiration, JsonNode value) {
                this.expiration = expiration;
                this.value = value;
            }
        }
    }

    public static interface Callback {
        public JsonNode execute();
    }

    public static class DefaultCache {
        private static Cache defaultCache = new BuiltInCache(999);

        private DefaultCache() {
        }

        public static Cache getInstance() {
            return defaultCache;
        }
    }

    public static class NoCache
    implements Cache {
        @Override
        public void set(String key, Long ttl, JsonNode response) {
        }

        @Override
        public JsonNode get(String key) {
            return null;
        }

        @Override
        public JsonNode getOrSet(String key, Long ttl, Callback f) {
            return f.execute();
        }
    }
}

