/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.model.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.common.model.v1.TestReport;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.commons.optimize.Optimizer;
import io.probedock.client.commons.optimize.v1.TestRunOptimizer;
import java.util.ArrayList;
import java.util.List;

public class TestRun
implements ProbeTestRun {
    private static final String API_VERSION = "v1";
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="version")
    private String projectVersion;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="results")
    private List<TestResult> testResults = new ArrayList<TestResult>();
    @JsonProperty(value="reports")
    private List<TestReport> testReports = new ArrayList<TestReport>();

    @Override
    public String getApiVersion() {
        return API_VERSION;
    }

    @Override
    @JsonIgnore
    public Optimizer getOptimizer() {
        return new TestRunOptimizer();
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    public List<TestReport> getTestReports() {
        return this.testReports;
    }

    public String toString() {
        StringBuilder sbTestResults = new StringBuilder();
        StringBuilder sbTestReports = new StringBuilder();
        for (TestResult testResult : this.testResults) {
            sbTestResults.append(testResult).append(", ");
        }
        for (TestReport testReport : this.testReports) {
            sbTestResults.append(testReport).append(", ");
        }
        return "TestRun: [ProjectId: " + this.projectId + ", " + "Version: " + this.projectVersion + ", " + "Duration: " + this.duration + ", " + "Results: [" + sbTestResults.toString().replaceAll(", $", "") + "]" + "Reports: [" + sbTestReports.toString().replaceAll(", $", "") + "]" + "]";
    }
}

