/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.commons.optimize.v1;

import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.common.model.v1.TestReport;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.model.v1.TestRun;
import io.probedock.client.common.utils.FootprintGenerator;
import io.probedock.client.commons.optimize.Optimizer;
import io.probedock.client.commons.optimize.OptimizerStore;
import java.util.Map;

public class TestRunOptimizer
implements Optimizer {
    @Override
    public ProbeTestRun optimize(OptimizerStore store, ProbeTestRun optimizable) {
        if (store == null) {
            throw new IllegalArgumentException("The optimizer store cannot be null");
        }
        if (optimizable == null) {
            throw new IllegalArgumentException("The optimizable object cannot be null");
        }
        if (optimizable.getClass() != TestRun.class) {
            throw new IllegalArgumentException("The test run given is not the one that is expected.");
        }
        TestRun originalTestRun = (TestRun)optimizable;
        TestRun optimizedTestRun = this.copyTestRun(originalTestRun);
        for (TestResult originalResult : originalTestRun.getTestResults()) {
            String footprint = this.footprint(originalResult);
            optimizedTestRun.getTestResults().add(this.copyTestResult(originalResult, store.testHasChanged(originalTestRun.getProjectId(), originalTestRun.getProjectVersion(), originalResult.getKey(), footprint)));
            store.storeTestFootprint(originalTestRun.getProjectId(), originalTestRun.getProjectVersion(), originalResult.getKey(), footprint);
        }
        return optimizedTestRun;
    }

    private TestRun copyTestRun(TestRun testRun) {
        TestRun newTestRun = new TestRun();
        newTestRun.setProjectId(testRun.getProjectId());
        newTestRun.setProjectVersion(testRun.getProjectVersion());
        newTestRun.setDuration(testRun.getDuration());
        for (TestReport testReport : testRun.getTestReports()) {
            newTestRun.getTestReports().add(this.copyTestReport(testReport));
        }
        return newTestRun;
    }

    private TestResult copyTestResult(TestResult testResult, boolean full) {
        TestResult newTestResult = new TestResult();
        newTestResult.setDuration(testResult.getDuration());
        newTestResult.setKey(testResult.getKey());
        newTestResult.setPassed(testResult.isPassed());
        newTestResult.setMessage(testResult.getMessage());
        if (full) {
            newTestResult.setActive(testResult.isActive());
            newTestResult.setCategory(testResult.getCategory());
            newTestResult.setName(testResult.getName());
            newTestResult.addTags(testResult.getTags());
            newTestResult.addTickets(testResult.getTickets());
            newTestResult.addData(testResult.getData());
        }
        return newTestResult;
    }

    private TestReport copyTestReport(TestReport testReport) {
        TestReport newTestReport = new TestReport();
        newTestReport.setUid(testReport.getUid());
        return newTestReport;
    }

    private String footprint(TestResult testResult) {
        StringBuilder sb = new StringBuilder();
        sb.append(testResult.getCategory()).append(testResult.getName()).append(testResult.isActive());
        for (String string : testResult.getTags()) {
            sb.append(string);
        }
        for (String string : testResult.getTickets()) {
            sb.append(string);
        }
        for (Map.Entry entry : testResult.getData().entrySet()) {
            sb.append((String)entry.getKey()).append((String)entry.getValue());
        }
        return FootprintGenerator.footprint(sb.toString());
    }
}

