/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.cache;

import io.probedock.client.common.config.Configuration;
import io.probedock.client.commons.optimize.OptimizerStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheOptimizerStore
implements OptimizerStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheOptimizerStore.class);
    private Configuration configuration;
    private Map<CacheKey, Map<String, String>> caches = new HashMap<CacheKey, Map<String, String>>();

    @Override
    public void start(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void stop(boolean persist) {
        if (persist) {
            this.persistCaches();
        }
    }

    @Override
    public boolean testHasChanged(String projectName, String projectVersion, String key, String footprint) {
        String cachedFootprint;
        Map<String, String> cache = this.getCache(projectName, projectVersion);
        return footprint == null || (cachedFootprint = cache.get(key)) == null || !footprint.equals(cachedFootprint);
    }

    @Override
    public void storeTestFootprint(String project, String version, String key, String footprint) {
        this.getCache(project, version).put(key, footprint);
    }

    public void cleanCaches() {
        try {
            FileUtils.cleanDirectory((File)this.getCacheDir());
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to clean the cache directory.", (Throwable)ioe);
        }
    }

    private Map<String, String> getCache(String projectName, String projectVersion) {
        if (!this.caches.containsKey(this.getCacheKey(projectName, projectVersion))) {
            this.caches.put(this.getCacheKey(projectName, projectVersion), this.loadOrCreateCache(projectName, projectVersion));
        }
        return this.caches.get(this.getCacheKey(projectName, projectVersion));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> loadOrCreateCache(String projectName, String projectVersion) {
        File versionFile;
        if (projectName == null) return new HashMap<String, String>();
        if (projectVersion == null) return new HashMap<String, String>();
        File projectDir = new File(this.getCacheDir(), projectName);
        if (!projectDir.exists()) {
            projectDir.mkdir();
        }
        if (!(versionFile = new File(projectDir, projectVersion)).exists()) return new HashMap<String, String>();
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(versionFile));){
            Map map = (Map)ois.readObject();
            return map;
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to read the cache for {}-{}", (Object)projectName, (Object)projectVersion);
            return new HashMap<String, String>();
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warn("The cache for {}-{} is corrupted.", (Object)projectName, (Object)projectVersion);
        }
        return new HashMap<String, String>();
    }

    private CacheKey getCacheKey(String projectName, String projectVersion) {
        return new CacheKey(projectName, projectVersion);
    }

    private File getCacheDir() {
        File probeDockCacheDir;
        File cacheDir = new File(this.configuration.getOptimizerCacheDir());
        if (!cacheDir.exists()) {
            cacheDir.mkdir();
        }
        if (!(probeDockCacheDir = new File(cacheDir, this.configuration.getServerConfiguration().getBaseUrlFootprint())).exists()) {
            probeDockCacheDir.mkdirs();
        }
        return probeDockCacheDir;
    }

    private void persistCaches() {
        for (Map.Entry<CacheKey, Map<String, String>> cacheEntry : this.caches.entrySet()) {
            this.persistCache(cacheEntry.getKey().projectName, cacheEntry.getKey().projectVersion, cacheEntry.getValue());
        }
    }

    private void persistCache(String projectId, String projectVersion, Map<String, String> cache) {
        File cacheFile = new File(this.getCacheDir(), projectId + "/" + projectVersion);
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cacheFile));){
            oos.writeObject(cache);
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to create the cache file {}/{}/{}", new Object[]{this.getCacheDir().getAbsoluteFile(), projectId, projectVersion});
        }
    }

    private class CacheKey
    implements Serializable {
        private String projectName;
        private String projectVersion;

        private CacheKey(String projectName, String projectVersion) {
            this.projectName = projectName;
            this.projectVersion = projectVersion;
        }

        public boolean equals(Object obj) {
            return this.projectName.equals(((CacheKey)obj).projectName) && this.projectVersion.equals(((CacheKey)obj).projectVersion);
        }

        public int hashCode() {
            return this.projectName.hashCode() * 3 + this.projectVersion.hashCode() * 5;
        }
    }
}

