/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.filters;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class FilterTargetData {
    private final String tags;
    private final String tickets;
    private final String name;
    private final String technicalName;
    private final String key;

    public String getKey() {
        return this.key;
    }

    public FilterTargetData(Method m, ProbeTest mAnnotation, ProbeTestClass cAnnotation) {
        this.tags = FilterTargetData.mergeTags(mAnnotation, cAnnotation);
        this.tickets = FilterTargetData.mergeTickets(mAnnotation, cAnnotation);
        this.name = FilterTargetData.testName(m, mAnnotation);
        this.technicalName = m.getDeclaringClass() + "." + m.getName();
        this.key = mAnnotation != null ? mAnnotation.key() : "";
    }

    public FilterTargetData(String tags, String tickets, String technicalName, String name, String key) {
        this.tags = tags;
        this.tickets = tickets;
        this.name = name;
        this.technicalName = technicalName;
        this.key = key;
    }

    public boolean anyMatch(String lookupAny) {
        return this.keyMatch(lookupAny) || this.nameMatch(lookupAny) || this.tagMatch(lookupAny) || this.ticketMatch(lookupAny);
    }

    public boolean keyMatch(String lookupKey) {
        if (this.key.isEmpty()) {
            return this.technicalName.contains(lookupKey);
        }
        return this.key.contains(lookupKey);
    }

    boolean nameMatch(String lookupName) {
        return this.name.contains(lookupName);
    }

    boolean tagMatch(String lookupTag) {
        return this.tags.contains(lookupTag);
    }

    boolean ticketMatch(String lookupTicket) {
        return this.tickets.contains(lookupTicket);
    }

    private static String testName(Method method, ProbeTest mAnnotation) {
        if (mAnnotation.name() != null && !mAnnotation.name().isEmpty()) {
            return mAnnotation.name();
        }
        return method.getName();
    }

    private static String mergeTags(ProbeTest mAnnotation, ProbeTestClass cAnnotation) {
        ArrayList<String> tags = new ArrayList<String>();
        if (mAnnotation != null) {
            tags.addAll(Arrays.asList(mAnnotation.tags()));
        }
        if (cAnnotation != null) {
            tags.addAll(Arrays.asList(cAnnotation.tags()));
        }
        return Arrays.toString(tags.toArray(new String[tags.size()]));
    }

    private static String mergeTickets(ProbeTest mAnnotation, ProbeTestClass cAnnotation) {
        ArrayList<String> tickets = new ArrayList<String>();
        if (mAnnotation != null) {
            tickets.addAll(Arrays.asList(mAnnotation.tickets()));
        }
        if (cAnnotation != null) {
            tickets.addAll(Arrays.asList(cAnnotation.tickets()));
        }
        return Arrays.toString(tickets.toArray(new String[tickets.size()]));
    }
}

