/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.model.v1;

import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.model.v1.TestReport;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.model.v1.TestRun;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelFactory {
    public static TestRun createTestRun(String projectApiId, String projectVersion, long duration, List<TestResult> testResults, List<TestReport> testReports) {
        if (testResults == null || testResults.isEmpty()) {
            throw new IllegalArgumentException("At least one test must be present.");
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration cannot be negative.");
        }
        TestRun testRun = new TestRun();
        testRun.setProjectId(projectApiId);
        testRun.setProjectVersion(projectVersion);
        testRun.setDuration(duration);
        String uid = Configuration.getInstance().getCurrentUid();
        if (uid != null && !uid.isEmpty()) {
            testRun.setUid(uid);
        }
        testRun.getTestResults().addAll(testResults);
        if (testReports != null && !testReports.isEmpty()) {
            testRun.getTestReports().addAll(testReports);
        }
        return testRun;
    }

    public static TestResult createTestResult(String key, String name, String category, long duration, String message, boolean passed, Boolean active, Set<String> tags, Set<String> tickets, Map<String, String> data) {
        TestResult testResult = new TestResult();
        if (!passed) {
            if (message == null) {
                testResult.setMessage("No message provided for the failing testResult");
            } else if (message.isEmpty()) {
                testResult.setMessage("No content for the message provided for the failing testResult");
            }
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration cannot be negative.");
        }
        if (key != null && !key.isEmpty()) {
            testResult.setKey(key);
        }
        testResult.setName(name);
        testResult.setDuration(duration);
        testResult.setPassed(passed);
        if (testResult.getMessage() == null) {
            if (message != null && message.getBytes(Charset.forName("UTF-8")).length > 50000) {
                testResult.setMessage(new String(message.getBytes(Charset.forName("UTF-8")), 0, 49997, Charset.forName("UTF-8")) + "...");
            } else {
                testResult.setMessage(message);
            }
        }
        if (category != null && !category.isEmpty()) {
            testResult.setCategory(category);
        }
        if (active != null) {
            testResult.setActive(active);
        }
        if (tags != null) {
            testResult.addTags(tags);
        }
        if (tickets != null) {
            testResult.addTickets(tickets);
        }
        if (data != null) {
            testResult.addData(data);
        }
        return testResult;
    }

    public static TestReport createTestReport(String uid) {
        return new TestReport(uid);
    }
}

