/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FootprintGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FootprintGenerator.class);

    public static String footprint(String stringToFootprint) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return FootprintGenerator.byteArrayToHexString(md.digest(stringToFootprint.getBytes()));
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.warn("Unable to calculate the footprint for string [{}].", (Object)stringToFootprint);
            return null;
        }
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            result.append(Integer.toString((byteArray[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

