/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.utils;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.utils.FingerprintGenerator;
import io.probedock.client.utils.CollectionHelper;
import java.util.Set;

public class TestResultDataUtils {
    public static String getKey(ProbeTest annotation) {
        return annotation != null && annotation.key() != null && !annotation.key().isEmpty() ? annotation.key() : null;
    }

    public static Boolean isActive(ProbeTest annotation) {
        return annotation != null ? Boolean.valueOf(annotation.active()) : null;
    }

    public static String getCategory(Configuration configuration, ProbeTestClass classAnnotation, ProbeTest methodAnnotation, String defaultCategory) {
        if (methodAnnotation != null && methodAnnotation.category() != null && !methodAnnotation.category().isEmpty()) {
            return methodAnnotation.category();
        }
        if (classAnnotation != null && classAnnotation.category() != null && !classAnnotation.category().isEmpty()) {
            return classAnnotation.category();
        }
        if (configuration.getCategory() != null && !configuration.getCategory().isEmpty()) {
            return configuration.getCategory();
        }
        return defaultCategory;
    }

    public static Set<String> getContributors(Configuration configuration, ProbeTestClass classAnnotation, ProbeTest methodAnnotation) {
        return CollectionHelper.getContributors(configuration.getContributors(), methodAnnotation, classAnnotation);
    }

    public static Set<String> getTags(Configuration configuration, ProbeTestClass classAnnotation, ProbeTest methodAnnotation) {
        return CollectionHelper.getTags(configuration.getTags(), methodAnnotation, classAnnotation);
    }

    public static Set<String> getTickets(Configuration configuration, ProbeTestClass classAnnotation, ProbeTest methodAnnotation) {
        return CollectionHelper.getTickets(configuration.getTickets(), methodAnnotation, classAnnotation);
    }

    public static String getTechnicalName(Class testClass, String methodName) {
        return testClass.getSimpleName() + "." + methodName;
    }

    public static String getFingerprint(Class testClass, String methodName) {
        return FingerprintGenerator.fingerprint(testClass, methodName);
    }
}

