/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.filters;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.utils.Inflector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class FilterTargetData {
    private final String tags;
    private final String tickets;
    private final String name;
    private final String technicalName;
    private final String key;
    private final String fingerprint;

    public String getKey() {
        return this.key;
    }

    public FilterTargetData(String fingerprint, Method m, ProbeTest mAnnotation, ProbeTestClass cAnnotation) {
        this.tags = FilterTargetData.mergeTags(mAnnotation, cAnnotation);
        this.tickets = FilterTargetData.mergeTickets(mAnnotation, cAnnotation);
        this.name = Inflector.forgeName(m.getDeclaringClass(), m.getName(), mAnnotation);
        this.technicalName = m.getDeclaringClass().getCanonicalName() + "." + m.getName();
        this.key = mAnnotation != null ? mAnnotation.key() : "";
        this.fingerprint = fingerprint;
    }

    public FilterTargetData(String fingerprint, Method m) {
        this.tags = "[]";
        this.tickets = "[]";
        this.name = Inflector.forgeName(m.getDeclaringClass(), m.getName(), null);
        this.technicalName = m.getDeclaringClass().getCanonicalName() + "." + m.getName();
        this.key = "";
        this.fingerprint = fingerprint;
    }

    public FilterTargetData(String fingerprint, String tags, String tickets, String technicalName, String name, String key) {
        this.tags = tags;
        this.tickets = tickets;
        this.name = name;
        this.technicalName = technicalName;
        this.key = key;
        this.fingerprint = fingerprint;
    }

    boolean anyMatch(String lookupAny) {
        return this.keyMatch(lookupAny) || this.fingerpringMatch(lookupAny) || this.nameMatch(lookupAny) || this.tagMatch(lookupAny) || this.ticketMatch(lookupAny);
    }

    boolean keyMatch(String lookupKey) {
        if (this.key.isEmpty()) {
            return this.technicalName.contains(lookupKey);
        }
        return this.key.contains(lookupKey);
    }

    boolean fingerpringMatch(String fingerprint) {
        return this.fingerprint.contains(fingerprint);
    }

    boolean nameMatch(String lookupName) {
        return this.name.contains(lookupName) || this.technicalName.contains(lookupName);
    }

    boolean tagMatch(String lookupTag) {
        return this.tags.contains(lookupTag);
    }

    boolean ticketMatch(String lookupTicket) {
        return this.tickets.contains(lookupTicket);
    }

    public String toString() {
        return "key: " + this.key + ", " + "name: " + this.name + ", " + "technicalName: " + this.technicalName + ", " + "fingerprint: " + this.fingerprint + ", " + "tags: " + this.tags + ", " + "tickets: " + this.tickets;
    }

    private static String mergeTags(ProbeTest mAnnotation, ProbeTestClass cAnnotation) {
        ArrayList<String> tags = new ArrayList<String>();
        if (mAnnotation != null) {
            tags.addAll(Arrays.asList(mAnnotation.tags()));
        }
        if (cAnnotation != null) {
            tags.addAll(Arrays.asList(cAnnotation.tags()));
        }
        return Arrays.toString(tags.toArray(new String[tags.size()]));
    }

    private static String mergeTickets(ProbeTest mAnnotation, ProbeTestClass cAnnotation) {
        ArrayList<String> tickets = new ArrayList<String>();
        if (mAnnotation != null) {
            tickets.addAll(Arrays.asList(mAnnotation.tickets()));
        }
        if (cAnnotation != null) {
            tickets.addAll(Arrays.asList(cAnnotation.tickets()));
        }
        return Arrays.toString(tickets.toArray(new String[tickets.size()]));
    }
}

