/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.storage;

import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.core.serializer.ProbeSerializer;
import io.probedock.client.core.serializer.json.JsonSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class FileStore {
    private static final Logger LOGGER = Logger.getLogger(FileStore.class.getCanonicalName());
    private Configuration configuration;
    private ProbeSerializer serializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStore(Configuration configuration) {
        this.configuration = configuration;
        if (configuration.getSerializer() == null) {
            LOGGER.info("Default serializer " + JsonSerializer.class.getName() + " will be used.");
            this.serializer = new JsonSerializer();
        } else {
            try {
                this.serializer = (ProbeSerializer)this.getClass().getClassLoader().loadClass(configuration.getSerializer()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.log(Level.WARNING, "Unable to create the serializer " + configuration.getSerializer() + ", default one will be used.", e);
            }
            finally {
                this.serializer = new JsonSerializer();
            }
        }
    }

    public void save(ProbeTestRun probeTestRun) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.getTmpDir(probeTestRun), UUID.randomUUID().toString())), Charset.forName("UTF-8").newEncoder());
        this.serializer.serializePayload(osw, probeTestRun, true);
    }

    public <T extends ProbeTestRun> T load(String name, Class<T> clazz) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(new File(this.getTmpDir(clazz), name)), Charset.forName("UTF-8").newDecoder());
        return this.serializer.deserializePayload(isr, clazz);
    }

    public <T extends ProbeTestRun> List<T> load(Class<T> clazz) throws IOException {
        ArrayList<T> payloads = new ArrayList<T>();
        for (File f : this.getTmpDir(clazz).listFiles()) {
            if (!f.isFile()) continue;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("UTF-8").newDecoder());
            payloads.add(this.serializer.deserializePayload(isr, clazz));
        }
        return payloads;
    }

    public void clear(Class<? extends ProbeTestRun> clazz) throws IOException {
        FileUtils.cleanDirectory((File)this.getTmpDir(clazz));
    }

    private File getTmpDir(ProbeTestRun testRun) {
        File tmpDir = new File(this.configuration.getWorkspace() + "/tmp/" + testRun.getVersion());
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    private File getTmpDir(Class<? extends ProbeTestRun> clazz) {
        try {
            return this.getTmpDir(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException iae) {
            return null;
        }
    }
}

