/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.common.config.ScmInfo;
import io.probedock.client.common.config.ServerListConfiguration;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigurationFile
extends AbstractFileConfiguration {
    private Yaml yaml = new Yaml();
    private String rootNodeName;
    private String serversProperty;
    private String categoriesByPackage;
    private String scm;
    private ServerListConfiguration serverList;
    private ScmInfo scmInfo;

    public YamlConfigurationFile(String filename, String rootNodeName, ServerListConfiguration serverList, ScmInfo scmInfo) throws ConfigurationException {
        this.rootNodeName = rootNodeName;
        this.serversProperty = rootNodeName + ".servers";
        this.categoriesByPackage = rootNodeName + ".java.categoriesByPackage";
        this.scm = rootNodeName + ".scm";
        this.serverList = serverList;
        this.scmInfo = scmInfo;
        this.setFileName(filename);
        this.load();
    }

    public void load(Reader in) throws ConfigurationException {
        boolean previousAutoSave = this.isAutoSave();
        this.setAutoSave(false);
        Object document = this.yaml.load(in);
        if (!(document instanceof Map)) {
            throw new ConfigurationException("Probe Dock configuration must be a map.");
        }
        this.loadYamlValue(document, this.rootNodeName);
        this.setAutoSave(previousAutoSave);
    }

    private void loadYamlValue(Object value, String path) throws ConfigurationException {
        if (value instanceof Map) {
            if (path.equals(this.serversProperty)) {
                this.loadServers((Map)value);
                return;
            }
            if (path.equals(this.scm)) {
                this.scmInfo.configureWith((Map)value);
            }
            if (path.equals(this.categoriesByPackage)) {
                this.addProperty(path, value);
            }
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.loadYamlValue(map.get(key), path + "." + key.toString());
            }
        } else if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> stringList = new ArrayList<String>(list.size());
            for (Object element : list) {
                if (element == null) continue;
                stringList.add(element.toString());
            }
            this.addPropertyDirect(path, stringList);
        } else {
            this.addProperty(path, value);
        }
    }

    public void save(Writer out) throws ConfigurationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void loadServers(Map<String, Object> data) throws ConfigurationException {
        for (String name : data.keySet()) {
            if (!(data.get(name) instanceof Map)) {
                throw new ConfigurationException("Server \"" + name + "\" (at " + this.serversProperty + "." + name + ") must be a map");
            }
            this.serverList.configureServer(name, (Map)data.get(name));
        }
    }
}

