/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.filters;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import io.probedock.client.common.utils.FingerprintGenerator;
import io.probedock.client.core.filters.FilterDefinition;
import io.probedock.client.core.filters.FilterTargetData;
import java.lang.reflect.Method;
import java.util.List;

public class FilterUtils {
    public static boolean isRunnable(Class cl, String methodName, List<FilterDefinition> filters) {
        try {
            Method method = cl.getMethod(methodName, new Class[0]);
            return FilterUtils.isRunnable(cl, method, filters);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return true;
        }
    }

    public static boolean isRunnable(Class cl, Method method, List<FilterDefinition> filters) {
        ProbeTest mAnnotation = method.getAnnotation(ProbeTest.class);
        ProbeTestClass cAnnotation = method.getDeclaringClass().getAnnotation(ProbeTestClass.class);
        String fingerprint = FingerprintGenerator.fingerprint(cl, method);
        if (mAnnotation != null || cAnnotation != null) {
            return FilterUtils.isRunnable(new FilterTargetData(fingerprint, method, mAnnotation, cAnnotation), filters);
        }
        return FilterUtils.isRunnable(new FilterTargetData(fingerprint, method), filters);
    }

    public static boolean isRunnable(String fingerprint, String name, String technicalName, String key, String tags, String tickets, List<FilterDefinition> filters) {
        return FilterUtils.isRunnable(new FilterTargetData(fingerprint, tags, tickets, technicalName, name, key), filters);
    }

    private static boolean isRunnable(FilterTargetData targetData, List<FilterDefinition> filters) {
        if (filters == null || filters.isEmpty()) {
            return true;
        }
        for (FilterDefinition filterDefinition : filters) {
            String type = filterDefinition.getType();
            String text = filterDefinition.getText();
            if (type == null || type.isEmpty()) {
                type = "*";
            }
            if (!(type.equalsIgnoreCase("*") && targetData.anyMatch(text) || "key".equalsIgnoreCase(type) && targetData.keyMatch(text) || "fp".equalsIgnoreCase(type) && targetData.fingerpringMatch(text) || "name".equalsIgnoreCase(type) && targetData.nameMatch(text) || "tag".equalsIgnoreCase(type) && targetData.tagMatch(text)) && (!"ticket".equalsIgnoreCase(type) || !targetData.ticketMatch(text))) continue;
            return true;
        }
        return false;
    }
}

