/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.common.config.ScmRemoteInfo;
import io.probedock.client.utils.ConfigurationUtils;
import io.probedock.client.utils.EnvironmentUtils;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;

public class ScmInfo {
    public static final String ENV_SCM_NAME = "SCM_NAME";
    public static final String ENV_SCM_VERSION = "SCM_VERSION";
    public static final String ENV_SCM_DIRTY = "SCM_DIRTY";
    public static final String ENV_SCM_BRANCH = "SCM_BRANCH";
    public static final String ENV_SCM_COMMIT = "SCM_COMMIT";
    private String name;
    private String version;
    private Boolean dirty;
    private String branch;
    private String commit;
    private ScmRemoteInfo remote = new ScmRemoteInfo();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ScmRemoteInfo getRemote() {
        return this.remote;
    }

    public void setRemote(ScmRemoteInfo remote) {
        this.remote = remote;
    }

    public Boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(Boolean dirty) {
        this.dirty = dirty;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public void configureWith(Map<String, Object> data) throws ConfigurationException {
        this.name = ConfigurationUtils.configureString(this.name, data, "name");
        this.version = ConfigurationUtils.configureString(this.version, data, "version");
        this.branch = ConfigurationUtils.configureString(this.branch, data, "branch");
        this.commit = ConfigurationUtils.configureString(this.commit, data, "commit");
        this.dirty = ConfigurationUtils.configureBoolean(this.dirty, data, "dirty");
        Object value = data.get("remote");
        if (value != null) {
            if (!(value instanceof Map)) {
                throw new ConfigurationException("The \"remote\" must be a map.");
            }
            this.remote.configureWith((Map)value);
        }
    }

    public void overrideByEnvVars() {
        this.name = EnvironmentUtils.getEnvironmentString(ENV_SCM_NAME, this.name);
        this.version = EnvironmentUtils.getEnvironmentString(ENV_SCM_VERSION, this.version);
        this.dirty = EnvironmentUtils.getEnvironmentBoolean(ENV_SCM_DIRTY, this.dirty);
        this.branch = EnvironmentUtils.getEnvironmentString(ENV_SCM_BRANCH, this.branch);
        this.commit = EnvironmentUtils.getEnvironmentString(ENV_SCM_COMMIT, this.commit);
        this.remote.overrideByEnvVars();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name: \"").append(this.name).append("\"");
        builder.append(", version: \"").append(this.version).append("\"");
        builder.append(", dirty: \"").append(this.dirty).append("\"");
        builder.append(", remote: \"").append(this.remote).append("\"");
        return builder.toString();
    }
}

