/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.config;

import io.probedock.client.utils.ConfigurationUtils;
import io.probedock.client.utils.EnvironmentUtils;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;

public class ScmRemoteInfo {
    public static final String ENV_SCM_REMOTE_NAME = "SCM_REMOTE_NAME";
    public static final String ENV_SCM_REMOTE_URL_FETCH = "SCM_REMOTE_URL_FETCH";
    public static final String ENV_SCM_REMOTE_URL_PUSH = "SCM_REMOTE_URL_PUSH";
    public static final String ENV_SCM_REMOTE_AHEAD = "SCM_REMOTE_AHEAD";
    public static final String ENV_SCM_REMOTE_BEHIND = "SCM_REMOTE_BEHIND";
    private String name;
    private String fetchUrl;
    private String pushUrl;
    private Integer ahead;
    private Integer behind;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFetchUrl() {
        return this.fetchUrl;
    }

    public void setFetchUrl(String fetchUrl) {
        this.fetchUrl = fetchUrl;
    }

    public String getPushUrl() {
        return this.pushUrl;
    }

    public void setPushUrl(String pushUrl) {
        this.pushUrl = pushUrl;
    }

    public Integer getAhead() {
        return this.ahead;
    }

    public void setAhead(Integer ahead) {
        this.ahead = ahead;
    }

    public Integer getBehind() {
        return this.behind;
    }

    public void setBehind(Integer behind) {
        this.behind = behind;
    }

    public void configureWith(Map<String, Object> data) throws ConfigurationException {
        this.name = ConfigurationUtils.configureString(this.name, data, "name");
        Object value = data.get("url");
        if (value != null) {
            if (!(value instanceof Map)) {
                throw new ConfigurationException("The \"url\" must be a map.");
            }
            Map url = (Map)value;
            this.fetchUrl = ConfigurationUtils.configureString(this.fetchUrl, url, "fetch");
            this.pushUrl = ConfigurationUtils.configureString(this.pushUrl, url, "push");
        }
        this.ahead = ConfigurationUtils.configureInteger(this.ahead, data, "ahead");
        this.behind = ConfigurationUtils.configureInteger(this.behind, data, "behind");
    }

    public void overrideByEnvVars() {
        this.name = EnvironmentUtils.getEnvironmentString(ENV_SCM_REMOTE_NAME, this.name);
        this.fetchUrl = EnvironmentUtils.getEnvironmentString(ENV_SCM_REMOTE_URL_FETCH, this.fetchUrl);
        this.pushUrl = EnvironmentUtils.getEnvironmentString(ENV_SCM_REMOTE_URL_PUSH, this.pushUrl);
        this.ahead = EnvironmentUtils.getEnvironmentInteger(ENV_SCM_REMOTE_AHEAD, this.ahead);
        this.behind = EnvironmentUtils.getEnvironmentInteger(ENV_SCM_REMOTE_BEHIND, this.behind);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name: \"").append(this.name).append("\"");
        builder.append(", fetchUrl: \"").append(this.fetchUrl).append("\"");
        builder.append(", pushUrl: \"").append(this.pushUrl).append("\"");
        builder.append(", ahead: \"").append(this.ahead).append("\"");
        builder.append(", behind: \"").append(this.behind).append("\"");
        return builder.toString();
    }
}

