/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.common.model.v1;

import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.config.ScmInfo;
import io.probedock.client.common.config.ScmRemoteInfo;
import io.probedock.client.common.model.v1.Context;
import io.probedock.client.common.model.v1.Probe;
import io.probedock.client.common.model.v1.TestReport;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.model.v1.TestRun;
import io.probedock.client.common.utils.FingerprintGenerator;
import io.probedock.client.common.utils.MetaDataBuilder;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelFactory {
    public static String createFingerprint(Class cl, Method m) {
        return FingerprintGenerator.fingerprint(cl, m);
    }

    public static Context createContext(Configuration config) {
        Context context = new Context();
        context.setProperty("os.name", System.getProperty("os.name"));
        context.setProperty("os.version", System.getProperty("os.version"));
        context.setProperty("os.architecture", System.getProperty("os.arch"));
        context.setProperty("java.version", System.getProperty("java.version"));
        context.setProperty("java.vendor", System.getProperty("java.vendor"));
        context.setProperty("java.runtime.name", System.getProperty("java.runtime.name"));
        context.setProperty("java.runtime.version", System.getProperty("java.runtime.version"));
        context.setProperty("java.vm.name", System.getProperty("java.vm.name"));
        context.setProperty("java.vm.version", System.getProperty("java.vm.version"));
        context.setProperty("java.vm.vendor", System.getProperty("java.vm.vendor"));
        context.setProperty("java.vm.specification.name", System.getProperty("java.vm.specification.name"));
        context.setProperty("java.vm.specification.version", System.getProperty("java.vm.specification.version"));
        context.setProperty("java.vm.specification.vendor", System.getProperty("java.vm.specification.vendor"));
        context.setProperty("java.specification.name", System.getProperty("java.specification.name"));
        context.setProperty("java.specification.version", System.getProperty("java.specification.version"));
        context.setProperty("java.specification.vendor", System.getProperty("java.specification.vendor"));
        context.setProperty("java.class.version", System.getProperty("java.class.version"));
        context.setPreProperty("memory.total", Runtime.getRuntime().totalMemory());
        context.setPreProperty("memory.free", Runtime.getRuntime().freeMemory());
        context.setPreProperty("memory.used", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        if (config.getScmInfo() != null) {
            ScmInfo scmInfo = config.getScmInfo();
            context.setPropertyNullAvoided("scm.name", scmInfo.getName());
            context.setPropertyNullAvoided("scm.version", scmInfo.getVersion());
            context.setPropertyNullAvoided("scm.dirty", scmInfo.isDirty());
            context.setPropertyNullAvoided("scm.branch", scmInfo.getBranch());
            context.setPropertyNullAvoided("scm.commit", scmInfo.getCommit());
            if (scmInfo.getRemote() != null) {
                ScmRemoteInfo scmRemoteInfo = scmInfo.getRemote();
                context.setPropertyNullAvoided("scm.remote.name", scmRemoteInfo.getName());
                context.setPropertyNullAvoided("scm.remote.url.fetch", scmRemoteInfo.getFetchUrl());
                context.setPropertyNullAvoided("scm.remote.url.push", scmRemoteInfo.getPushUrl());
                context.setPropertyNullAvoided("scm.remote.ahead", scmRemoteInfo.getAhead());
                context.setPropertyNullAvoided("scm.remote.behind", scmRemoteInfo.getBehind());
            }
        }
        return context;
    }

    public static void enrichContext(Context context) {
        context.setPostProperty("memory.total", Runtime.getRuntime().totalMemory());
        context.setPostProperty("memory.free", Runtime.getRuntime().freeMemory());
        context.setPostProperty("memory.used", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public static Probe createProbe(String name, String version) {
        return new Probe(name, version);
    }

    public static TestRun createTestRun(Configuration config, Context context, Probe probe, String projectId, String version, String pipeline, String stage, List<TestReport> testReports, Map<String, String> data) {
        String uid;
        if (context == null) {
            throw new IllegalArgumentException("Execution context must be present.");
        }
        if (probe == null) {
            throw new IllegalArgumentException("Probe info must be present.");
        }
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("The project version must be present.");
        }
        if (projectId == null || projectId.isEmpty()) {
            throw new IllegalArgumentException("The project ID must be present.");
        }
        TestRun testRun = new TestRun();
        testRun.setContext(context);
        testRun.setProbe(probe);
        testRun.setProjectId(projectId);
        testRun.setVersion(version);
        if (pipeline != null && !pipeline.isEmpty()) {
            testRun.setPipeline(pipeline);
        }
        if (stage != null && !stage.isEmpty()) {
            testRun.setStage(stage);
        }
        if ((uid = config.getCurrentUid()) != null && !uid.isEmpty()) {
            testRun.getTestReports().add(new TestReport(uid));
            testRun.addData("probedock.report.uid", uid);
        }
        if (testReports != null && !testReports.isEmpty()) {
            testRun.getTestReports().addAll(testReports);
        }
        if (data != null && !data.isEmpty()) {
            testRun.addData(data);
        }
        return testRun;
    }

    public static TestResult createTestResult(String key, String fingerprint, String name, String category, long duration, String message, boolean passed, Boolean active, Set<String> contributors, Set<String> tags, Set<String> tickets, Map<String, String> data) {
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration cannot be negative.");
        }
        if (fingerprint == null || fingerprint.isEmpty()) {
            throw new IllegalArgumentException("The fingerprint is mandatory.");
        }
        TestResult testResult = new TestResult();
        if (!passed) {
            if (message == null) {
                testResult.setMessage("No message available.");
            } else if (message.isEmpty()) {
                testResult.setMessage("Failing message was empty.");
            }
        }
        if (key != null && !key.isEmpty()) {
            testResult.setKey(key);
        }
        testResult.setFingerprint(fingerprint);
        testResult.setName(name);
        testResult.setDuration(duration);
        testResult.setPassed(passed);
        if (testResult.getMessage() == null) {
            if (message != null && message.getBytes(Charset.forName("UTF-8")).length > 50000) {
                testResult.setMessage(new String(message.getBytes(Charset.forName("UTF-8")), 0, 49997, Charset.forName("UTF-8")) + "...");
            } else {
                testResult.setMessage(message);
            }
        }
        if (category != null && !category.isEmpty()) {
            testResult.setCategory(category);
        }
        if (active != null) {
            testResult.setActive(active);
        }
        if (tags != null) {
            testResult.addTags(tags);
        }
        if (contributors != null) {
            testResult.addContributors(contributors);
        }
        if (tickets != null) {
            testResult.addTickets(tickets);
        }
        if (data != null) {
            testResult.addData(data);
        }
        testResult.addData("fingerprint", fingerprint);
        return testResult;
    }

    public static void enrichTestResult(Configuration config, TestResult result, String packageName, String className, String methodName, int lineNumber) {
        MetaDataBuilder builder = new MetaDataBuilder();
        builder.add("java.package", packageName != null ? packageName : "defaultPackage").add("java.class", className).add("java.method", methodName);
        if (lineNumber >= 0) {
            builder.add("file.line", "" + lineNumber);
        }
        String basePath = "";
        if (config.getProjectBaseTestPath() != null) {
            basePath = config.getProjectBaseTestPath().replaceAll("\\\\", "/");
        }
        if (packageName == null) {
            builder.add("file.path", Paths.get(basePath, className + ".java").toString());
        } else {
            builder.add("file.path", Paths.get(basePath, packageName.replaceAll("\\.", "/"), className + ".java").toString());
        }
        result.addData(builder.toMetaData());
    }

    public static TestReport createTestReport(String uid) {
        return new TestReport(uid);
    }
}

