/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.core.connector;

import io.probedock.client.common.config.Configuration;
import io.probedock.client.common.config.ServerConfiguration;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.core.serializer.ProbeSerializer;
import io.probedock.client.core.serializer.json.JsonSerializer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Connector {
    private static final Logger LOGGER = Logger.getLogger(Connector.class.getCanonicalName());
    private static final String CONTENT_TYPE = "application/vnd.probe-dock.payload.v1+json";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int CONNECTION_READ_TIMEOUT = 60000;
    private Configuration configuration;
    private ProbeSerializer serializer;

    public Connector(Configuration configuration) {
        this.configuration = configuration;
        this.serializer = new JsonSerializer();
    }

    public boolean send(ProbeTestRun testRun) throws MalformedURLException {
        LOGGER.info("Connected to Probe Dock API at " + this.configuration.getServerConfiguration().getApiUrl());
        if (this.configuration.isPayloadPrint()) {
            try (OutputStreamWriter testRunOsw = new OutputStreamWriter(System.out);){
                this.serializer.serializePayload(testRunOsw, testRun, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sendTestRun(testRun);
    }

    private URL getTestRunUrl() throws MalformedURLException {
        return new URL(this.configuration.getServerConfiguration().getApiUrl() + "/publish");
    }

    private boolean sendTestRun(ProbeTestRun testRun) {
        block25: {
            HttpURLConnection conn = null;
            try {
                try {
                    conn = this.uploadTestRun(testRun);
                }
                catch (SocketTimeoutException ste) {
                    LOGGER.log(Level.SEVERE, "Unable to send the results to the server due to a timeout exception", ste);
                    throw ste;
                }
                try {
                    if (conn.getResponseCode() == 202) {
                        LOGGER.info("The test run was successfully sent to Probe Dock.");
                        return true;
                    }
                    LOGGER.severe("Unable to send the test run to Probe Dock. Return code: " + conn.getResponseCode() + ", content: " + this.readInputStream(conn.getInputStream()));
                }
                catch (SocketTimeoutException ste) {
                    LOGGER.log(Level.SEVERE, "Unable to read the response from the server du to a timeout exception", ste);
                    throw ste;
                }
            }
            catch (IOException ioe) {
                if (this.configuration.isPayloadPrint()) break block25;
                try (OutputStreamWriter baos = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), Charset.forName("UTF-8").newEncoder());){
                    this.serializer.serializePayload(baos, testRun, true);
                    LOGGER.severe("The test run in error: " + baos.toString());
                }
                catch (IOException baosIoe) {
                    // empty catch block
                }
                if (conn != null) {
                    try {
                        if (conn.getErrorStream() != null) {
                            LOGGER.severe("Unable to send the test run to Probe Dock. Error: " + this.readInputStream(conn.getErrorStream()));
                        }
                        LOGGER.log(Level.SEVERE, "Unable to send the test run to Probe Dock. This is probably due to an unreachable network issue.", ioe);
                    }
                    catch (IOException errorIoe) {
                        LOGGER.severe("Unable to send the test run to Probe Dock for unknown reason.");
                    }
                }
                LOGGER.log(Level.SEVERE, "Unable to send the test run to Probe Dock.", ioe);
            }
        }
        return false;
    }

    private HttpURLConnection uploadTestRun(ProbeTestRun testRun) throws IOException {
        HttpURLConnection conn = this.openConnection(this.configuration.getServerConfiguration(), this.getTestRunUrl());
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/vnd.probe-dock.payload.v1+json; charset=UTF-8");
        conn.setRequestProperty("Authorization", "Bearer " + this.configuration.getServerConfiguration().getApiToken());
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(60000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream(), Charset.forName("UTF-8").newEncoder());
        this.serializer.serializePayload(osw, testRun, false);
        return conn;
    }

    private String readInputStream(InputStream in) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8").newDecoder()));
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }

    private HttpURLConnection openConnection(ServerConfiguration configuration, URL url) throws IOException {
        if (configuration.hasProxyConfiguration()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(configuration.getProxyConfiguration().getHost(), configuration.getProxyConfiguration().getPort()));
            return (HttpURLConnection)url.openConnection(proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }
}

