/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.client.utils;

import io.probedock.client.annotations.ProbeTest;
import io.probedock.client.annotations.ProbeTestClass;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CollectionHelper {
    private static final Logger LOGGER = Logger.getLogger(CollectionHelper.class.getCanonicalName());
    private static final Pattern tagPattern = Pattern.compile("[a-zA-z0-9-_]*");
    private static final Pattern emailPattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");

    public static Set<String> getContributors(Set<String> baseContributors, ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        Set<Object> contributors = baseContributors == null ? new HashSet() : CollectionHelper.populateContributors(baseContributors, new HashSet<String>());
        if (classAnnotation != null && classAnnotation.contributors() != null) {
            contributors = CollectionHelper.populateContributors(new HashSet<String>(Arrays.asList(classAnnotation.contributors())), contributors);
        }
        if (methodAnnotation != null && methodAnnotation.contributors() != null) {
            contributors = CollectionHelper.populateContributors(new HashSet<String>(Arrays.asList(methodAnnotation.contributors())), contributors);
        }
        return contributors;
    }

    private static Set<String> populateContributors(Set<String> source, Set<String> destination) {
        for (String contributor : source) {
            if (!emailPattern.matcher(contributor).matches()) {
                LOGGER.warning("The contributor '" + contributor + "' does not respect the email pattern " + emailPattern.pattern() + " and is ignored");
                continue;
            }
            if (destination.contains(contributor)) {
                LOGGER.info("The contributor '" + contributor + "' is already present in the collection and is ignored");
                continue;
            }
            destination.add(contributor);
        }
        return destination;
    }

    public static Set<String> getTags(Set<String> baseTags, ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        Set<Object> tags = baseTags == null ? new HashSet() : CollectionHelper.populateTags(baseTags, new HashSet<String>());
        if (classAnnotation != null && classAnnotation.tags() != null) {
            tags = CollectionHelper.populateTags(new HashSet<String>(Arrays.asList(classAnnotation.tags())), tags);
        }
        if (methodAnnotation != null && methodAnnotation.tags() != null) {
            tags = CollectionHelper.populateTags(new HashSet<String>(Arrays.asList(methodAnnotation.tags())), tags);
        }
        return tags;
    }

    private static Set<String> populateTags(Set<String> source, Set<String> destination) {
        for (String tag : source) {
            if (!tagPattern.matcher(tag).matches()) {
                LOGGER.warning("The tag " + tag + " does not respect the following pattern " + tagPattern.pattern() + " and is ignored");
                continue;
            }
            if (destination.contains(tag)) {
                LOGGER.info("The tag " + tag + " is already present in the collection and is ingored");
                continue;
            }
            destination.add(tag);
        }
        return destination;
    }

    public static Set<String> getTickets(Set<String> basedTickets, ProbeTest methodAnnotation, ProbeTestClass classAnnotation) {
        Set<Object> tickets = basedTickets == null ? new HashSet() : CollectionHelper.populateTickets(basedTickets, new HashSet<String>());
        if (classAnnotation != null && classAnnotation.tickets() != null) {
            tickets = CollectionHelper.populateTickets(new HashSet<String>(Arrays.asList(classAnnotation.tickets())), tickets);
        }
        if (methodAnnotation != null && methodAnnotation.tickets() != null) {
            tickets = CollectionHelper.populateTickets(new HashSet<String>(Arrays.asList(methodAnnotation.tickets())), tickets);
        }
        return tickets;
    }

    private static Set<String> populateTickets(Set<String> source, Set<String> destination) {
        for (String ticket : source) {
            if (destination.contains(ticket)) {
                LOGGER.info("The ticket " + ticket + " is already present in the collection and is ingored");
                continue;
            }
            destination.add(ticket);
        }
        return destination;
    }
}

